% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_and_get.R
\name{get_dset.purse}
\alias{get_dset.purse}
\title{Gets a named data set and performs checks}
\usage{
\method{get_dset}{purse}(x, dset, Time = NULL, also_get = NULL, ...)
}
\arguments{
\item{x}{A purse class object}

\item{dset}{A character string corresponding to a named data set within each coin \code{.$Data}. E.g. \code{"Raw"}.}

\item{Time}{Optional time index to extract from a subset of the coins present in the purse. Should be a
vector containing one or more entries in \code{x$Time} or \code{NULL} to return all (default).}

\item{also_get}{A character vector specifying any columns to attach to the data set that are \emph{not}
indicators or aggregates. These will be e.g. \code{uName}, groups, denominators or columns labelled as "Other"
in \code{iMeta}. These columns are stored in \code{.$Meta$Unit} to avoid repetition. Set \code{also_get = "all"} to
attach all columns, or set \code{also_get = "none"} to return only numeric columns, i.e. no \code{uCode} column.}

\item{...}{arguments passed to or from other methods.}
}
\value{
Data frame of indicator data.
}
\description{
A helper function to retrieve a named data set from a purse object. Retrieves the specified data set
from each coin in the purse and joins them together in a single data frame using \code{\link[=rbind]{rbind()}}, indexed
with a \code{Time} column.
}
\examples{
# build example purse
purse <- build_example_purse(up_to = "new_coin", quietly = TRUE)

# get raw data set
df1 <- get_dset(purse, dset = "Raw")

}
