% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{synAntPlot}
\alias{synAntPlot}
\title{This function prints and saves 2D and 3D plots of synergy/antagonism.}
\usage{
synAntPlot(processedData, xConcentration, yConcentration, xDrug, yDrug,
  cellLine)
}
\arguments{
\item{processedData}{A matrix to plot.}

\item{xConcentration}{X drug concentrations.}

\item{yConcentration}{Y drug concentrations.}

\item{xDrug}{X drug name.}

\item{yDrug}{Y drug name.}

\item{cellLine}{Cell line name.}
}
\value{
Plot the values.
}
\description{
This function prints and saves 2D and 3D plots of synergy/antagonism.
}
\examples{
dataFile <- system.file("/raw/processedData.csv", package="COMBIA")
procData <- read.csv( dataFile, header=FALSE)
xConc <- c(0.00,  0.20, 0.39, 0.78,  1.56,  3.12,  6.25, 12.50, 25.00, 50)
yConc <- c(128,  64,  32,  16,   8,   4,   2,   0)
xD <- "X_Drug"
yD <- "Y_Drug"
clN <- "myCell"
rslt <- synAntPlot(as.matrix(procData),xConc,yConc, xD, yD, clN)
}
\author{
Muhammad kashif
}

