% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{extractKey}
\alias{extractKey}
\title{Extracts the barcodes from  a dataset, each experimental plate has a barcode in a dataset.
Barcodes are extracted from the header of the each plate data from  position specified by keyposition argument.}
\usage{
extractKey(keyposition, rawdata, numberofrowsperplate, doubleplateexperiment)
}
\arguments{
\item{keyposition}{Position of keyvalue in the header of plate.}

\item{rawdata}{An object(dataframe) of rawdata.}

\item{numberofrowsperplate}{This argument is not needed when you call function "readFluostarPlates". The number of rows depend upon the
geometry of the plates. These are 16 in case of 384 well plates.}

\item{doubleplateexperiment}{This parameter has TRUE or FALSE value only. It is TRUE when an experiment is read
twice and one only want to choose only one of them.}
}
\value{
Barcodes.
}
\description{
Extracts the barcodes from  a dataset, each experimental plate has a barcode in a dataset.
Barcodes are extracted from the header of the each plate data from  position specified by keyposition argument.
}
\examples{
f <- system.file("/raw/optima.log", package="COMBIA")
fileDF <- readFile(filename = f,  separator = ",", noofrows_skip=0,
                   platetype="384")
Generatedbarcode <- extractKey(keyposition = 2, rawdata = fileDF,
                              numberofrowsperplate = 17,
                              doubleplateexperiment = FALSE)
}
\author{
Muhammad Kashif
}

