% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmp-reg.R
\name{glm.cmp, CMP support}
\alias{glm.cmp, CMP support}
\alias{summary.cmp}
\alias{print.cmp}
\alias{logLik.cmp}
\alias{AIC.cmp}
\alias{BIC.cmp}
\alias{coef.cmp}
\alias{nu.cmp}
\alias{sdev.cmp}
\alias{vcov.cmp}
\alias{leverage.cmp}
\alias{deviance.cmp}
\alias{residuals.cmp}
\alias{predict.cmp}
\alias{parametric.bootstrap.cmp}
\title{Supporting Functions for COM-Poisson Regression}
\usage{
\method{summary}{cmp}(object, ...)

\method{print}{cmp}(x, ...)

\method{logLik}{cmp}(object, ...)

\method{AIC}{cmp}(object, ..., k = 2)

\method{BIC}{cmp}(object, ...)

\method{coef}{cmp}(object, ...)

\method{nu}{cmp}(object, ...)

\method{sdev}{cmp}(object, ...)

\method{vcov}{cmp}(object, ...)

\method{leverage}{cmp}(object, ...)

\method{deviance}{cmp}(object, ...)

\method{residuals}{cmp}(object, type = c("raw", "quantile"), ...)

\method{predict}{cmp}(object, newdata = NULL, ...)

\method{parametric.bootstrap}{cmp}(object, reps = 1000,
  report.period = reps + 1, ...)
}
\arguments{
\item{object}{object of type \code{cmp}.}

\item{...}{other model parameters, such as data.}

\item{x}{object of type \code{cmp}.}

\item{k}{Penalty per parameter to be used in AIC calculation.}

\item{type}{Type of residual to be computed.}

\item{newdata}{New covariates to be used for prediction.}

\item{reps}{Number of bootstrap repetitions.}

\item{report.period}{Report progress every \code{report.period} iterations.}
}
\description{
Supporting Functions for COM-Poisson Regression
}
