% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPGLIB_Prediction_Functions.R
\name{predict.cv.CPGLIB}
\alias{predict.cv.CPGLIB}
\title{Predictions for cv.ProxGrad Object}
\usage{
\method{predict}{cv.CPGLIB}(
  object,
  newx,
  groups = NULL,
  ensemble_type = c("Model-Avg", "Coef-Avg", "Weighted-Prob", "Majority-Vote")[1],
  class_type = c("prob", "class")[1],
  ...
)
}
\arguments{
\item{object}{An object of class cv.CPGLIB.}

\item{newx}{New data for predictions.}

\item{groups}{The groups in the ensemble for the predictions. Default is all of the groups in the ensemble.}

\item{ensemble_type}{The type of ensembling function for the models. Options are "Model-Avg", "Coef-Avg" or "Weighted-Prob" for 
classifications predictions. Default is "Model-Avg".}

\item{class_type}{The type of predictions for classification. Options are "prob" and "class". Default is "prob".}

\item{...}{Additional arguments for compatibility.}
}
\value{
The predictions for the cv.CPGLIB object.
}
\description{
\code{predict.cv.CPGLIB} returns the predictions for a ProxGrad object.
}
\examples{
\donttest{
# Data simulation
set.seed(1)
n <- 50
N <- 2000
p <- 300
beta.active <- c(abs(runif(p, 0, 1/2))*(-1)^rbinom(p, 1, 0.3))
# Parameters
p.active <- 150
beta <- c(beta.active[1:p.active], rep(0, p-p.active))
Sigma <- matrix(0, p, p)
Sigma[1:p.active, 1:p.active] <- 0.5
diag(Sigma) <- 1

# Train data
x.train <- mvnfast::rmvn(n, mu = rep(0, p), sigma = Sigma) 
prob.train <- exp(x.train \%*\% beta)/
              (1+exp(x.train \%*\% beta))
y.train <- rbinom(n, 1, prob.train)
# Test data
x.test <- mvnfast::rmvn(N, mu = rep(0, p), sigma = Sigma)
prob.test <- exp(x.test \%*\% beta)/
             (1+exp(x.test \%*\% beta))
y.test <- rbinom(N, 1, prob.test)
mean(y.test)

# CV CPGLIB - Multiple Groups
cpg.out <- cv.cpg(x.train, y.train,
                  glm_type = "Logistic",
                  G = 5, include_intercept = TRUE,
                  alpha_s = 3/4, alpha_d = 1,
                  n_lambda_sparsity = 100, n_lambda_diversity = 100,
                  tolerance = 1e-5, max_iter = 1e5)

# Predictions
cpg.prob <- predict(cpg.out, newx = x.test, type = "prob", 
                    groups = 1:cpg.out$G, ensemble_type = "Model-Avg")
cpg.class <- predict(cpg.out, newx = x.test, type = "class", 
                     groups = 1:cpg.out$G, ensemble_type = "Model-Avg")
plot(prob.test, cpg.prob, pch = 20)
abline(h = 0.5,v = 0.5)
mean((prob.test-cpg.prob)^2)
mean(abs(y.test-cpg.class))

}


}
\seealso{
\code{\link{cv.cpg}}
}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
