% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AccumulationExceedingThreshold.R
\name{CST_AccumulationExceedingThreshold}
\alias{CST_AccumulationExceedingThreshold}
\title{Accumulation of a variable when Exceeding (not exceeding) a Threshold}
\usage{
CST_AccumulationExceedingThreshold(
  data,
  threshold,
  op = ">",
  diff = FALSE,
  start = NULL,
  end = NULL,
  time_dim = "ftime",
  na.rm = FALSE,
  ncores = NULL
)
}
\arguments{
\item{data}{a 's2dv_cube' object as provided by function \code{CST_Load} in package CSTools.}

\item{threshold}{a 's2dv_cube' object as output of a 'CST_' function in the same units as parameter 'data' and with the common dimensions of the element 'data' of the same length. A single scalar is also possible.}

\item{op}{a opartor '>' (by default), '<', '>=' or '<='.}

\item{diff}{a logical value indicating whether to accumulate the difference between data and threshold (TRUE) or not (FALSE by default).}

\item{start}{an optional parameter to defined the initial date of the period to select from the data by providing a list of two elements: the initial date of the period and the initial month of the period. By default it is set to NULL and the indicator is computed using all the data provided in \code{data}.}

\item{end}{an optional parameter to defined the final date of the period to select from the data by providing a list of two elements: the final day of the period and the final month of the period. By default it is set to NULL and the indicator is computed using all the data provided in \code{data}.}

\item{time_dim}{a character string indicating the name of the function to compute the indicator. By default, it is set to 'ftime'. More than one dimension name matching the dimensions provided in the object \code{data$data} can be specified.}

\item{na.rm}{a logical value indicating whether to ignore NA values (TRUE) or not (FALSE).}

\item{ncores}{an integer indicating the number of cores to use in parallel computation.}
}
\value{
A 's2dv_cube' object containing the indicator in the element \code{data}.
}
\description{
The accumulation (sum) of a variable in the days (or time steps) that the variable is exceeding (or not exceeding) a threshold during a period. The threshold provided must be 
in the same units than the variable units, i.e. to use a percentile as a scalar, 
the function \code{Threshold} or \code{QThreshold} may be needed. 
Providing mean daily temperature data, the following agriculture indices for heat stress can be obtained by using this function:
\itemize{
 \item\code{GDD}{Summation of daily differences between daily average temperatures and 10°C between April 1st and October 31st}}
}
\examples{
exp <- CSTools::lonlat_data$exp
exp$data <- CSTools::lonlat_data$exp$data[1, 5, 3, 3, 1, 1]
DOT <- CST_AccumulationExceedingThreshold(exp, threshold = 280)
}
