% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TotalTimeExceedingThreshold.R
\name{TotalTimeExceedingThreshold}
\alias{TotalTimeExceedingThreshold}
\title{Total Time of a variable Exceeding (not exceeding) a Threshold}
\usage{
TotalTimeExceedingThreshold(
  data,
  threshold,
  op = ">",
  dates = NULL,
  start = NULL,
  end = NULL,
  time_dim = "time",
  na.rm = FALSE,
  ncores = NULL
)
}
\arguments{
\item{data}{a multidimensional array with named dimensions.}

\item{threshold}{a multidimensional array with named dimensions in the same units as parameter \code{data} and with the common dimensions of the element \code{data} of the same length (e.g. an array with the same lengths of longitude and latitude). A single scalar is also possible (for the case of comparing all grid points with the same scalar).}

\item{op}{a opartor '>' (by default), '<', '>=' or '<='.}

\item{dates}{a vector of dates or a multidimensional array of dates with named dimensions matching the dimensions on parameter 'data'. By default it is NULL, to select a period this parameter must be provided.}

\item{start}{an optional parameter to defined the initial date of the period to select from the data by providing a list of two elements: the initial date of the period and the initial month of the period. By default it is set to NULL and the indicator is computed using all the data provided in \code{data}.}

\item{end}{an optional parameter to defined the final date of the period to select from the data by providing a list of two elements: the final day of the period and the final month of the period. By default it is set to NULL and the indicator is computed using all the data provided in \code{data}.}

\item{time_dim}{a character string indicating the name of the function to compute the indicator. By default, it is set to 'time'. More than one dimension name matching the dimensions provided in the object \code{data$data} can be specified.}

\item{na.rm}{a logical value indicating whether to ignore NA values (TRUE) or  not (FALSE).}

\item{ncores}{an integer indicating the number of cores to use in parallel computation.}
}
\value{
A multidimensional array with named dimensions.
}
\description{
The Total Time of a variable exceeding (or not) a Threshold returns the total number of days 
(if the data provided is daily, or the corresponding units to the data frequency provided)
that a variable is exceeding a threshold during a period. The threshold provided must be 
in the same units than the variable units, i.e. to use a percentile as a threshold, 
the function \code{Threshold} or \code{QThreshold} may be needed (see examples). 
Providing maximum temperature daily data, the following agriculture indices for heat stress can be obtained by using this function:
\itemize{
 \item\code{SU35}{Total count of days when daily maximum temperatures exceed 35°C}
 \item\code{SU36}{Total count of days when daily maximum temperatures exceed 36 between June 21st and September 21st}
 \item\code{SU40}{Total count of days when daily maximum temperatures exceed 40 between June 21st and September 21st}
 \item\code{Spr32}{Total count of days when daily maximum temperatures exceed 32 between April 21st and June 21st}
}
}
\examples{
exp <- CSTools::lonlat_data$exp$data[1, 5, 3, 3, 1, 1]
DOT <- TotalTimeExceedingThreshold(exp, threshold = 300, time_dim = 'ftime')

}
