% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_QuantileMapping.R
\name{CST_QuantileMapping}
\alias{CST_QuantileMapping}
\title{Quantiles Mapping for seasonal or decadal forecast data}
\usage{
CST_QuantileMapping(
  exp,
  obs,
  exp_cor = NULL,
  sample_dims = c("sdate", "ftime", "member"),
  sample_length = NULL,
  method = "QUANT",
  ncores = NULL,
  ...
)
}
\arguments{
\item{exp}{an object of class \code{s2dv_cube}}

\item{obs}{an object of class \code{s2dv_cube}}

\item{exp_cor}{an object of class \code{s2dv_cube} in which the quantile mapping correction will be applied. If it is not specified, the correction is applied in object \code{exp}.}

\item{sample_dims}{a character vector indicating the dimensions that can be used as sample for the same distribution}

\item{sample_length}{a numeric value indicating the length of the timeseries window to be used as sample for the sample distribution and correction. By default, NULL, the total length of the timeseries will be used.}

\item{method}{a character string indicating the method to be used: 'PTF','DIST','RQUANT','QUANT','SSPLIN'. By default, the empirical quantile mapping 'QUANT' is used.}

\item{ncores}{an integer indicating the number of parallel processes to spawn for the use for parallel computation in multiple cores.}

\item{...}{additional arguments passed to the method specified by \code{method}.}
}
\value{
an oject of class \code{s2dv_cube} containing the experimental data after applyingthe quantile mapping correction. 
) <- c(dataset = 1, member = 10, sdate = 20, ftime = 60 ,
}
\description{
This function is a wrapper from fitQmap and doQmap from package 'qmap'to be applied in CSTools objects of class 's2dv_cube'. The quantile mapping adjustment between an experiment, tipically a hindcast, and observations is applied to the experiment itself or to a provided forecast.
}
\details{
The different methods are:
\itemize{ 
\item{'PTF'} {fits a parametric transformations to the quantile-quantile relation of observed and modelled values. See \code{?qmap::fitQmapPTF}.}
\item{'DIST'} {fits a theoretical distribution to observed and to modelled time series. See \code{?qmap::fitQmapDIST}.}
\item{'RQUANT'} {estimates the values of the quantile-quantile relation of observed and modelled time series for regularly spaced quantiles using local linear least square regression. See \code{?qmap::fitQmapRQUANT}.}
\item{'QUANT'} {estimates values of the empirical cumulative distribution function of observed and modelled time series for regularly spaced quantiles. See \code{?qmap::fitQmapQUANT}.}
\item{'SSPLIN'} {fits a smoothing spline to the quantile-quantile plot of observed and modelled time series. See \code{?qmap::fitQmapSSPLIN}.}}
All methods accepts some common arguments:
\itemize{
\item{wet.day} {logical indicating whether to perform wet day correction or not.(Not available in 'DIS' method)}
\item{qstep} {NULL or a numeric value between 0 and 1.}}
When providing a forecast to be corrected through the pararmeter \code{exp_cor}, some inputs might need to be modified. The quantile correction is compute by comparing objects passed through 'exp' and 'obs' parameters, this correction will be later applied to the forecast provided in 'exp_cor'. Imaging the case of 'exp' and 'obs' having several start dates, stored using a dimension e.g. 'sdate', 'sample_dims' include this dimension 'sdate' and 'exp_cor' has forecasts for several sdates but different from the ones in 'exp'. In this case, the correction computed with 'exp' and 'obs' would be applied for each 'sdate' of 'exp_cor' separately. This example corresponds to a case of split a dataset in training set and validation set.
}
\examples{
library(qmap)
exp <- 1 : (1 * 5 * 10 * 6 * 2 * 3)
dim(exp) <- c(dataset = 1, member = 10, sdate = 5, ftime = 6 , 
             lat = 2, lon = 3)
exp <- list(data = exp)
class(exp) <- 's2dv_cube'
obs <- 101 : (100 + 1 * 1 * 5 * 6 * 2 * 3)
dim(obs) <- c(dataset = 1, member = 1, sdate = 5, ftime = 6 ,
             lat = 2, lon = 3)
obs <- list(data = obs)
class(obs) <- 's2dv_cube'
res <- CST_QuantileMapping(exp, obs, method = 'RQUANT')
\donttest{
exp <- lonlat_data$exp
obs <- lonlat_data$obs
res <- CST_QuantileMapping(exp, obs)

exp_cor <- exp
exp_cor$data <- exp_cor$data[,,1,,,]
dim(exp_cor$data) <- c(dataset = 1, member = 15, sdate = 1, ftime = 3, 
                      lat = 22, lon = 53)
res <- CST_QuantileMapping(exp, obs, exp_cor,
                          sample_dims = c('sdate', 'ftime', 'member'))
res <- CST_QuantileMapping(exp, obs, exp_cor,
                          sample_dims = c('ftime', 'member'))
data(obsprecip)
data(modprecip)
exp <- modprecip$MOSS[1:10000]
dim(exp) <- c(time = length(exp))
exp <- list(data = exp)
class(exp) <- 's2dv_cube'
obs <- obsprecip$MOSS[1:10000]
dim(obs) <- c(time = length(obs))
obs <- list(data = obs)
class(obs) <- 's2dv_cube'
res <- CST_QuantileMapping(exp = exp, obs = obs, sample_dims = 'time',
                          method = 'DIST')
# Example using different lenght of members and sdates:
exp <- lonlat_data$exp
exp$data <- exp$data[,,1:4,,,]
dim(exp$data) <- c(dataset = 1, member = 15, sdate = 4, ftime = 3, 
                      lat = 22, lon = 53)
obs <- lonlat_data$obs
obs$data <- obs$data[,,1:4, ,,]
dim(obs$data) <- c(dataset = 1, member = 1, sdate = 4, ftime = 3, 
                      lat = 22, lon = 53)
exp_cor <- lonlat_data$exp
exp_cor$data <- exp_cor$data[,1:5,5:6,,,]
dim(exp_cor$data) <- c(dataset = 1, member = 5, sdate = 2, ftime = 3, 
                     lat = 22, lon = 53)
res <- CST_QuantileMapping(exp, obs, exp_cor,
                          sample_dims = c('sdate', 'ftime', 'member'))
exp_cor <- lonlat_data$exp
exp_cor$data <- exp_cor$data[,,5:6,,,]
dim(exp_cor$data) <- c(dataset = 1, member = 15, sdate = 2, ftime = 3, 
                      lat = 22, lon = 53)
res <- CST_QuantileMapping(exp, obs, exp_cor,
                          sample_dims = c('sdate', 'ftime', 'member'))
}
}
\seealso{
\code{qmap::fitQmap} and \code{qmap::doQmap}
}
\author{
Nuria Perez-Zanon, \email{nuria.perez@bsc.es}
}
