% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_ProxiesAttractor.R
\name{CST_ProxiesAttractor}
\alias{CST_ProxiesAttractor}
\title{Computing two dinamical proxies of the attractor in s2dv_cube.}
\usage{
CST_ProxiesAttractor(data, quanti, ncores = NULL)
}
\arguments{
\item{data}{a s2dv_cube object with the data to create the attractor. Must be a matrix with the timesteps in nrow 
and the grids in ncol(dat(time,grids)}

\item{quanti}{a number lower than 1 indicating the quantile to perform the computation of local dimension and theta}

\item{ncores}{The number of cores to use in parallel computation}
}
\value{
dim and theta
}
\description{
This function computes two dinamical proxies of the attractor: 
The local dimension (d) and the inverse of the persistence (theta) for an
's2dv_cube' object.
These two parameters will be used as a condition for the computation of dynamical 
scores to measure predictability and to compute bias correction conditioned  by
the dynamics with the function DynBiasCorrection  
Funtion based on the matlab code (davide.faranda@lsce.ipsl.fr) used in
}
\examples{
# Example 1: Computing the attractor using simple s2dv data
attractor <- CST_ProxiesAttractor(data = lonlat_data$obs, quanti = 0.6)

}
\references{
Faranda, D., Alvarez-Castro, M.C., Messori, G., Rodriguez, D., and Yiou, P. (2019). 
The hammam effect or how a warm ocean enhances large scale atmospheric predictability.
Nature Communications, 10(1), 1316. DOI = https://doi.org/10.1038/s41467-019-09305-8 "

Faranda, D., Gabriele Messori and Pascal Yiou. (2017).
Dynamical proxies of North Atlantic predictability and extremes. 
Scientific Reports, 7-41278, 2017.
}
\author{
Carmen Alvarez-Castro, \email{carmen.alvarez-castro@cmcc.it}

Maria M. Chaves-Montero, \email{mdm.chaves-montero@cmcc.it}

Veronica Torralba, \email{veronica.torralba@cmcc.it}

Davide Faranda, \email{davide.faranda@lsce.ipsl.fr}
}
