% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_MultivarRMSE.R
\name{CST_MultivarRMSE}
\alias{CST_MultivarRMSE}
\title{Multivariate Root Mean Square Error (RMSE)}
\usage{
CST_MultivarRMSE(
  exp,
  obs,
  weight = NULL,
  memb_dim = "member",
  dat_dim = "dataset",
  sdate_dim = "sdate",
  ftime_dim = "ftime"
)
}
\arguments{
\item{exp}{A list of objects, one for each variable, of class \code{s2dv_cube} 
as returned by \code{CST_Anomaly} function, containing the anomaly of the 
seasonal forecast experiment data in the element named \code{$data}.}

\item{obs}{A list of objects, one for each variable (in the same order than 
the input in 'exp') of class \code{s2dv_cube} as returned by 
\code{CST_Anomaly} function, containing the observed anomaly data in the 
element named \code{$data}.}

\item{weight}{(optional) A vector of weight values to assign to each variable. 
If no weights are defined, a value of 1 is assigned to every variable.}

\item{memb_dim}{A character string indicating the name of the member 
dimension. It must be one dimension in 'exp' and 'obs'. The default value is 
'member'.}

\item{dat_dim}{A character string indicating the name of the dataset 
dimension. It must be one dimension in 'exp' and 'obs'. If there is no 
dataset dimension, it can be NULL. The default value is 'dataset'.}

\item{sdate_dim}{A character string indicating the name of the start date 
dimension. It must be one dimension in 'exp' and 'obs'. The default value is 
'sdate'.}

\item{ftime_dim}{A character string indicating the name of the forecast time 
dimension. It must be one dimension in 'exp' and 'obs'. The default value is 
'ftime'.}
}
\value{
An object of class \code{s2dv_cube} containing the RMSE in the element 
 \code{$data} which is an array with two datset dimensions equal to the 
 'dataset' dimension in the \code{exp$data} and \code{obs$data} inputs. An 
 array with dimensions: c(number of exp, number of obs, 1 (the multivariate 
 RMSE value), number of lat, number of lon)
}
\description{
This function calculates the RMSE from multiple variables, as the 
mean of each variable's RMSE scaled by its observed standard deviation. 
Variables can be weighted based on their relative importance (defined by the 
user).
}
\examples{
# Example with 2 variables
mod1 <- abs(rnorm(1 * 3 * 4 * 5 * 6 * 7))
mod2 <- abs(rnorm(1 * 3 * 4 * 5 * 6 * 7))
dim(mod1) <- c(dataset = 1, member = 3, sdate = 4, ftime = 5, lat = 6, lon = 7)
dim(mod2) <- c(dataset = 1, member = 3, sdate = 4, ftime = 5, lat = 6, lon = 7)
obs1 <- abs(rnorm(1 * 1 * 4 * 5 * 6 * 7))
obs2 <- abs(rnorm(1 * 1 * 4 * 5 * 6 * 7))
dim(obs1) <- c(dataset = 1, member = 1, sdate = 4, ftime = 5, lat = 6, lon = 7)
dim(obs2) <- c(dataset = 1, member = 1, sdate = 4, ftime = 5, lat = 6, lon = 7)
lon <- seq(0, 30, 5)
lat <- seq(0, 25, 5)
coords <- list(lat = lat, lon = lon)
exp1 <- list(data = mod1, coords = coords, 
            attrs = list(Datasets = "EXP1", source_files = "file1", 
                         Variable = list(varName = 'pre')))
exp2 <- list(data = mod2, coords = coords, 
            attrs = list(Datasets = "EXP2", source_files = "file2", 
                         Variable = list(varName = 'tas')))
obs1 <- list(data = obs1, coords = coords, 
            attrs = list(Datasets = "OBS1", source_files = "file1", 
                         Variable = list(varName = 'pre')))
obs2 <- list(data = obs2, coords = coords, 
            attrs = list(Datasets = "OBS2", source_files = "file2", 
                         Variable = list(varName = 'tas')))
attr(exp1, 'class') <- 's2dv_cube'
attr(exp2, 'class') <- 's2dv_cube'
attr(obs1, 'class') <- 's2dv_cube'
attr(obs2, 'class') <- 's2dv_cube'
anom1 <- CST_Anomaly(exp1, obs1, cross = TRUE, memb = TRUE)
anom2 <- CST_Anomaly(exp2, obs2, cross = TRUE, memb = TRUE)
ano_exp <- list(anom1$exp, anom2$exp)
ano_obs <- list(anom1$obs, anom2$obs)
a <- CST_MultivarRMSE(exp = ano_exp, obs = ano_obs, weight = c(1, 2))
}
\seealso{
\code{\link[s2dv]{RMS}} and \code{\link{CST_Load}}
}
\author{
Deborah Verfaillie, \email{deborah.verfaillie@bsc.es}
}
