% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cubeforsim.R
\name{cubeforsim}
\alias{cubeforsim}
\title{Simulation routine for CUBE models without covariates}
\usage{
cubeforsim(m, ordinal, starting, maxiter = 500, toler = 1e-06, expinform=FALSE)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{starting}{Vector of initial parameters estimates to start the optimization algorithm}

\item{maxiter}{Maximum number of iterations allowed for running the optimization algorithm 
(defaul: maxiter = 500)}

\item{toler}{Fixed error tolerance for final estimates (default: toler = 1e-6)}

\item{expinform}{Logical: if TRUE, the function returns the expected variance covariance matrix
(default is FALSE)}
}
\value{
An object of the class "CUBE", with null output for $BIC since the routine is only for
 simulation purposes
}
\description{
Fit CUBE models without covariates to given ordinal data. It is useful for simulation experiments 
since it performs the same steps as the CUBE function, but with no printed output.
}
\examples{
data(relgoods)
m<-10
ordinal<-na.omit(relgoods[,37])
starting<-rep(0.1,3) 
simul<-cubeforsim(m,ordinal,starting)
param<-simul$estimates    # Estimated parameters vector (pai,csi,phi)
####################
data(univer)
m<-7
ordinal<-univer[,11]
starting<-rep(0.1,3)
simul<-cubeforsim(m,ordinal,starting)
param<-simul$estimates   # Estimated parameters vector (pai,csi,phi) 
}
\seealso{
\code{\link{CUBE}}, \code{\link{loglikCUBE}}
}
\keyword{htest}

