% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probcubshe2.R
\name{probcubshe2}
\alias{probcubshe2}
\title{probcubshe2}
\usage{
probcubshe2(m,pai,csi,delta,shelter)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{pai}{Uncertainty parameter}

\item{csi}{Feeling parameter}

\item{delta}{Shelter parameter}

\item{shelter}{Category corresponding to the shelter choice}
}
\value{
The vector of the probability distribution of a CUB model with explicit shelter effect.
}
\description{
Probability distribution of a CUB model with explicit shelter effect
}
\details{
A CUB model with explicit shelter effect is a mixture of two components: 
a CUB distribution with uncertainty parameter \eqn{\pi}  and feeling parameter \eqn{\xi}, 
and  a degenerate distribution with unit mass at the shelter category (\code{shelter}) 
with mixing coefficient specified by \eqn{\delta}.
}
\examples{
m<-8
pai1<-0.5
pai2<-0.3
csi<-0.4
shelter<-6
delta<-1-pai1-pai2
pai<-pai1/(1-delta)
pr2<-probcubshe2(m,pai,csi,delta,shelter)
plot(1:m,pr2,type="h", main="CUB probability distribution with 
explicit shelter effect",xlab="Ordinal categories")
points(1:m,pr2,pch=19)
}
\references{
Iannario M. (2012). Modelling \emph{shelter} choices in a class of mixture models for ordinal responses,  
\emph{Statistical Methods and Applications}, \bold{21}, 1--22 \cr
}
\seealso{
\code{\link{probcubshe1}}, \code{\link{probcubshe3}}
}
\keyword{distribution}
