% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_kernel.R
\name{kernel_polynomial}
\alias{kernel_polynomial}
\title{Generating A Single Matrix-wise Function Using Polynomial}
\usage{
kernel_polynomial(l, p, sigma)
}
\arguments{
\item{l}{(numeric) A numeric number indicating the hyperparameter
(flexibility) of a specific kernel.}

\item{p}{(integer) For polynomial, p is the power; for matern, v = p + 1 /
2; for rational, alpha = p.}

\item{sigma}{(numeric) The covariance coefficient for neural network kernel.}
}
\value{
\item{matrix_wise}{(function) A function calculating the relevance
of two matrices.}
}
\description{
Generate matrix-wise functions for two matrices using polynomial kernel.
}
\details{
\bold{Polynomial Kernels} \deqn{k(x, x')=(x \cdot x')^p} We have intercept
kernel when \eqn{p=0}, and linear kernel when \eqn{p=1}.
}
\references{
The MIT Press. Gaussian Processes for Machine Learning, 2006.
}
\author{
Wenying Deng
}
