% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable.R
\docType{class}
\name{SemidefUpperTri-class}
\alias{SemidefUpperTri-class}
\alias{.SemidefUpperTri}
\alias{SemidefUpperTri}
\alias{SemidefUpperTri}
\alias{as.character,SemidefUpperTri-method}
\alias{get_data,SemidefUpperTri-method}
\alias{canonicalize,SemidefUpperTri-method}
\alias{canonicalize,SymmetricUpperTri-method}
\title{The SemidefUpperTri class.}
\usage{
SemidefUpperTri(n, name = NA_character_)

\S4method{as.character}{SemidefUpperTri}(x)

\S4method{get_data}{SemidefUpperTri}(object)

\S4method{canonicalize}{SemidefUpperTri}(object)

\S4method{canonicalize}{SymmetricUpperTri}(object)
}
\arguments{
\item{n}{The number of rows/columns in the matrix.}

\item{name}{(Optional) A character string representing the name of the variable.}

\item{x, object}{A \linkS4class{SemidefUpperTri} object.}
}
\description{
This class represents the upper triangular part of a positive semidefinite variable.
}
\section{Methods (by generic)}{
\itemize{
\item \code{get_data}: Returns \code{list(n, name)}.

\item \code{canonicalize}: Enforce that the variable be positive semidefinite.

\item \code{canonicalize}: Enforce that the variable be symmetric.
}}

\section{Slots}{

\describe{
\item{\code{id}}{(Internal) A unique identification number used internally.}

\item{\code{n}}{The number of rows/columns in the matrix.}

\item{\code{rows}}{The number of rows in the variable.}

\item{\code{cols}}{The number of columns in the variable.}

\item{\code{name}}{(Optional) A character string representing the name of the variable.}

\item{\code{primal_value}}{(Internal) The primal value of the variable stored internally.}
}}

\examples{
x <- SemidefUpperTri(3)
as.character(x)
get_data(x)
canonicalize(x)
}
