% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{multiply}
\alias{multiply}
\alias{*}
\title{Elementwise Multiplication}
\usage{
multiply(lh_exp, rh_exp)
}
\arguments{
\item{lh_exp}{An \linkS4class{Expression}, vector, or matrix representing the left-hand value.}

\item{rh_exp}{An \linkS4class{Expression}, vector, or matrix representing the right-hand value.}
}
\value{
An \linkS4class{Expression} representing the elementwise product of the inputs.
}
\description{
The elementwise product of two expressions. The first expression must be constant.
}
\examples{
A <- Variable(2,2)
c <- cbind(c(1,-1), c(2,-2))
expr <- multiply(c, A)
obj <- Minimize(norm_inf(expr))
prob <- Problem(obj, list(A == 5))
result <- solve(prob)
result$value
result$getValue(expr)
}
