% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgp2dcp.R
\docType{class}
\name{Dgp2Dcp-class}
\alias{Dgp2Dcp-class}
\alias{Dgp2Dcp}
\alias{accepts,Dgp2Dcp,Problem-method}
\alias{perform,Dgp2Dcp,Problem-method}
\alias{canonicalize_expr,Dgp2Dcp-method}
\alias{invert,Dgp2Dcp,Solution,InverseData-method}
\title{Reduce DGP problems to DCP problems.}
\usage{
\S4method{accepts}{Dgp2Dcp,Problem}(object, problem)

\S4method{perform}{Dgp2Dcp,Problem}(object, problem)

\S4method{canonicalize_expr}{Dgp2Dcp}(object, expr, args)

\S4method{invert}{Dgp2Dcp,Solution,InverseData}(object, solution, inverse_data)
}
\arguments{
\item{object}{A \linkS4class{Dgp2Dcp} object.}

\item{problem}{A \linkS4class{Problem} object.}

\item{expr}{An \linkS4class{Expression} object corresponding to the DGP problem.}

\item{args}{A list of values corresponding to the DGP expression}

\item{solution}{A \linkS4class{Solution} object to invert.}

\item{inverse_data}{A \linkS4class{InverseData} object containing data necessary for the inversion.}
}
\description{
This reduction takes as input a DGP problem and returns an equivalent DCP
problem. Because every (generalized) geometric program is a DGP problem,
this reduction can be used to convert geometric programs into convex form.
}
\section{Methods (by generic)}{
\itemize{
\item \code{accepts(object = Dgp2Dcp, problem = Problem)}: Is the problem DGP?

\item \code{perform(object = Dgp2Dcp, problem = Problem)}: Converts the DGP problem to a DCP problem.

\item \code{canonicalize_expr(Dgp2Dcp)}: Canonicalizes each atom within an Dgp2Dcp expression.

\item \code{invert(object = Dgp2Dcp, solution = Solution, inverse_data = InverseData)}: Returns the solution to the original problem given the inverse_data.

}}
