% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{p_norm}
\alias{p_norm}
\title{P-Norm}
\usage{
p_norm(x, p = 2, axis = NA_real_, keepdims = FALSE, max_denom = 1024)
}
\arguments{
\item{x}{An \linkS4class{Expression}, vector, or matrix.}

\item{p}{A number greater than or equal to 1, or equal to positive infinity.}

\item{axis}{(Optional) The dimension across which to apply the function: \code{1} indicates rows, \code{2} indicates columns, and \code{NA} indicates rows and columns. The default is \code{NA}.}

\item{keepdims}{(Optional) Should dimensions be maintained when applying the atom along an axis? If \code{FALSE}, result will be collapsed into an \eqn{n x 1} column vector. The default is \code{FALSE}.}

\item{max_denom}{(Optional) The maximum denominator considered in forming a rational approximation for \eqn{p}. The default is 1024.}
}
\value{
An \linkS4class{Expression} representing the p-norm of the input.
}
\description{
The vector p-norm. If given a matrix variable, \code{p_norm} will treat it as a vector and compute the p-norm of the concatenated columns.
}
\details{
For \eqn{p \geq 1}, the p-norm is given by \deqn{\|x\|_p = \left(\sum_{i=1}^n |x_i|^p\right)^{1/p}} with domain \eqn{x \in \mathbf{R}^n}.
For \eqn{p < 1, p \neq 0}, the p-norm is given by \deqn{\|x\|_p = \left(\sum_{i=1}^n x_i^p\right)^{1/p}} with domain \eqn{x \in \mathbf{R}^n_+}.

\itemize{
   \item Note that the "p-norm" is actually a \strong{norm} only when \eqn{p \geq 1} or \eqn{p = +\infty}. For these cases, it is convex.
   \item The expression is undefined when \eqn{p = 0}.
   \item Otherwise, when \eqn{p < 1}, the expression is concave, but not a true norm.
}
}
\examples{
x <- Variable(3)
prob <- Problem(Minimize(p_norm(x,2)))
result <- solve(prob)
result$value
result$getValue(x)

prob <- Problem(Minimize(p_norm(x,Inf)))
result <- solve(prob)
result$value
result$getValue(x)

\dontrun{
  a <- c(1.0, 2, 3)
  prob <- Problem(Minimize(p_norm(x,1.6)), list(t(x) \%*\% a >= 1))
  result <- solve(prob)
  result$value
  result$getValue(x)

  prob <- Problem(Minimize(sum(abs(x - a))), list(p_norm(x,-1) >= 0))
  result <- solve(prob)
  result$value
  result$getValue(x)
}
}
