% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{vstack}
\alias{vstack}
\title{Vertical Concatenation}
\usage{
vstack(...)
}
\arguments{
\item{...}{\linkS4class{Expression} objects, vectors, or matrices. All arguments must have the same number of columns.}
}
\value{
An \linkS4class{Expression} representing the concatenated inputs.
}
\description{
The vertical concatenation of expressions. This is equivalent to \code{rbind} when applied to objects with the same number of columns.
}
\examples{
x <- Variable(2)
y <- Variable(3)
c <- matrix(1, nrow = 1, ncol = 5)
prob <- Problem(Minimize(c \%*\% vstack(x, y)), list(x == c(1,2), y == c(3,4,5)))
result <- solve(prob)
result$value

c <- matrix(1, nrow = 1, ncol = 4)
prob <- Problem(Minimize(c \%*\% vstack(x, x)), list(x == c(1,2)))
result <- solve(prob)
result$value

A <- Variable(2,2)
C <- Variable(3,2)
c <- matrix(1, nrow = 2, ncol = 2)
prob <- Problem(Minimize(sum(vstack(A, C))), list(A >= 2*c, C == -2))
result <- solve(prob)
result$value

B <- Variable(2,2)
c <- matrix(1, nrow = 1, ncol = 2)
prob <- Problem(Minimize(sum(vstack(c \%*\% A, c \%*\% B))), list(A >= 2, B == -2))
result <- solve(prob)
result$value
}
