% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solver_utilities.R
\name{installed_solvers}
\alias{installed_solvers}
\alias{add_to_solver_blacklist}
\alias{remove_from_solver_blacklist}
\alias{set_solver_blacklist}
\title{List installed solvers}
\usage{
installed_solvers()

add_to_solver_blacklist(solvers)

remove_from_solver_blacklist(solvers)

set_solver_blacklist(solvers)
}
\arguments{
\item{solvers}{a character vector of solver names, default \code{character(0)}}
}
\value{
The names of all the installed solvers as a character vector.

The current blacklist (character vector), invisibly.
}
\description{
List available solvers, taking currently blacklisted solvers into
account.
}
\section{Functions}{
\itemize{
\item \code{add_to_solver_blacklist}: Add to solver blacklist, useful for temporarily disabling a solver

\item \code{remove_from_solver_blacklist}: Remove solvers from blacklist

\item \code{set_solver_blacklist}: Set solver blacklist to a value
}}

