% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation.R
\name{EkfBE}
\alias{EkfBE}
\title{Correction vector estimation}
\usage{
EkfBE(
  refBatch,
  queBatch,
  pairs,
  sampling = FALSE,
  numSamples = NULL,
  verbose = FALSE
)
}
\arguments{
\item{refBatch}{Reference batch.}

\item{queBatch}{Query batch.}

\item{pairs}{A numerical matrix containing MNNs pairs cell indexes. First column corresponds to query batch cells.}

\item{sampling}{Sample MNNs pairs.}

\item{numSamples}{If sampling, number of MNNs pairs samples to use on the estimation process.}

\item{verbose}{Print output.}
}
\value{
A list containing the estimated correction vector and the estimation data.
The length of the correction vector is equal to the number of genes.
}
\description{
Batch effect estimation using an extended Kalman filter
}
\details{
The input batches must have the same number of genes. The model used on the estimation has the form of g_ref = g_que + be, where
the batch effect is represented as a value added to the reference gene expression, causing a linear deviation between the reference and
the query batches.
}
