% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RC.R
\name{Carlson_RC}
\alias{Carlson_RC}
\title{Carlson elliptic integral RC}
\usage{
Carlson_RC(x, y, minerror = 2 * .Machine$double.eps)
}
\arguments{
\item{x, y}{real or complex numbers, with \code{y} different from \code{0}}

\item{minerror}{bound on the relative error passed to \code{\link{Carlson_RF}}}
}
\value{
A complex number, the value of the Carlson elliptic integral
\ifelse{html}{\out{R<sub>C</sub>(x,y)}}{\eqn{R_C(x,y)}{RC(x,y)}}.
}
\description{
Evaluate the Carlson elliptic integral RC.
}
\note{
The function returns a value when \code{x} or \code{y}
are negative real numbers, but this value is not the one of the
Carlson integral.
}
\examples{
Carlson_RC(5, 2)
gsl::ellint_RC(5, 2)
}
