% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{terminalNodeIDs}
\alias{terminalNodeIDs}
\title{Get the terminal node id of a RandomForest Object}
\usage{
terminalNodeIDs(x, rfObject)
}
\arguments{
\item{x}{a data.frame}

\item{rfObject}{\code{ranger} object}
}
\value{
Matrix with terminal node IDs for all observations in x (rows) and
        trees (columns)
}
\description{
Extracts for each observation and for each tree in the forest the terminal 
node id.
}
\examples{
library(ranger)
rf.fit <- ranger(Species ~ ., data = iris, num.trees = 5, write.forest = TRUE)
dfNodes <- terminalNodeIDs(iris[, -5], rf.fit)

}
