% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/util.R
\name{bindagCausalEffectBackdoor}
\alias{bindagCausalEffectBackdoor}
\title{Estimates Average Causal Effects by Covariate Adjustment in Binary Models}
\usage{
bindagCausalEffectBackdoor(problem, prior_table, S)
}
\arguments{
\item{problem}{a \code{\link{cfx}} problem instance for the ACE of a given treatment \eqn{X} on a given outcome \eqn{Y}.}

\item{prior_table}{effective sample size hyperparameter of a Dirichlet prior for testing independence with contingency tables.}

\item{S}{an array indicating the indices of the covariates used in the adjustment.}
}
\value{
the estimated ACE.
}
\description{
Estimate the average causal effect (ACE) of a given treatment variable
\eqn{X} on a given outcome \eqn{Y} by adjusting for a set \eqn{S} of covariates (equivalenly, assuming
\eqn{S} blocks all backdoor paths in the causal graph that generates the observations). . Bounds are based on finding conditional instrumental variables
using the faithfulness assumption relaxed to allow for a moderate degree of unfaithfulness.
Candidate models are generated from the method described in \code{\link{covsearch}}.
}
\details{
The algorithm implemented is a naive one. If the dimensionality of \emph{S} is larger than around 20, this may crash the system.
This function is assumed to be used along other methods such as \code{\link{covsearch}} and \code{\link{wpp}}, which generate
relativelty small covariate sets.
}
\examples{
## Generate a synthetic problem
problem <- simulateWitnessModel(p = 4, q = 4, par_max = 3, M = 1000)

## Idealized case: suppose we know the true distribution,
## get "exact" ACE estimands for different adjustment sets
sol_pop <- covsearch(problem, pop_solve = TRUE)
effect_pop <- synthetizeCausalEffect(problem)
cat(sprintf(
  "ACE (true) = \%1.2f\\nACE (adjusting for all) = \%1.2f\\nACE (adjusting for nothing) = \%1.2f\\n",
   effect_pop$effect_real, effect_pop$effect_naive, effect_pop$effect_naive2))

## Perform inference and report results
covariate_hat <- covsearch(problem, cred_calc = TRUE, M = 1000)
if (length(covariate_hat$witness) > 1) {
  sol_ACE <- bindagCausalEffectBackdoor(problem, prior_table = 10, S = covariate_hat$Z[[1]])
  cat(sprintf("Estimated ACE = \%1.2f\\n", sol_ACE))
}
}
\references{
Pearl, J. (2000) \emph{Causality: Models, Reasoning and Inference}. Cambridge University Press.
}

