% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_parameters.R
\name{set_parameters}
\alias{set_parameters}
\title{Set parameters}
\usage{
set_parameters(
  model,
  parameters = NULL,
  param_type = NULL,
  warning = FALSE,
  ...
)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by \code{\link{make_model}}.}

\item{parameters}{A vector of real numbers in [0,1]. Values of parameters to specify (optional). By default, parameters is drawn from \code{model$parameters_df}.}

\item{param_type}{A character. String specifying type of parameters to set ('flat', 'prior_mean', 'posterior_mean', 'prior_draw', 'posterior_draw', 'define). With param_type set to \code{define} use arguments to be passed to \code{make_priors}; otherwise \code{flat} sets equal probabilities on each nodal param_type in each parameter set; \code{prior_mean}, \code{prior_draw}, \code{posterior_mean}, \code{posterior_draw} take parameters as the means or as draws from the prior or posterior.}

\item{warning}{Logical. Whether to warn about parameter renormalization}

\item{...}{Arguments to be passed to make_parameters}
}
\value{
An object of class \code{causal_model}. It essentially returns a list containing the elements comprising
a model (e.g. 'statement', 'nodal_types' and 'DAG') with true vector of parameters attached to it.
}
\description{
Add a true parameter vector to a model. Parameters can be created using arguments passed to
\code{\link{make_parameters}} and \code{\link{make_priors}}.
}
\details{
Argument 'param_type' is passed to make_priors and specifies  one of 'flat', 'prior_mean',
'posterior_mean', 'prior_draw', 'posterior_draw', and 'define'.
With param_type set to \code{define} use arguments to be passed to \code{make_priors}; otherwise
\code{flat} sets equal probabilities on each nodal param_type in each parameter set;
\code{prior_mean}, \code{prior_draw}, \code{posterior_mean}, \code{posterior_draw}
take parameters as the means or as draws from the prior or posterior.
}
\examples{
make_model('X->Y') \%>\% set_parameters(1:6) \%>\% get_parameters()

make_model('X -> Y') \%>\%
  set_confound(list(X = 'Y[X=1]>Y[X=0]'))  \%>\%
  set_parameters(confound = list(X='Y[X=1]>Y[X=0]', X='Y[X=1]<=Y[X=0]'),
                 parameters = list(c(.2, .8), c(.8, .2))) \%>\%
  set_parameters(statement = 'Y[X=1]>Y[X=0]', parameters = .5) \%>\%
  get_parameters
}
\seealso{
Other parameters: 
\code{\link{get_parameters}()},
\code{\link{make_parameters}()}
}
\concept{parameters}
