% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_helpers.R
\name{expand_data}
\alias{expand_data}
\title{Expand compact data object to data frame}
\usage{
expand_data(data_events = NULL, model)
}
\arguments{
\item{data_events}{A \code{data.frame}. It must be compatible with nodes in \code{model}. The default columns are \code{event}, \code{strategy} and \code{count}.}

\item{model}{A \code{causal_model}. A model object generated by \code{\link{make_model}}.}
}
\value{
A \code{data.frame} with rows as data observation
}
\description{
Expand compact data object to data frame
}
\examples{
\donttest{
model <- make_model('X->M->Y')
make_events(model, n = 5) \%>\%
  expand_data(model)
make_events(model, n = 0) \%>\%
  expand_data(model)
 }

}
