% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_con_ar2.R
\name{r.cond.ar2}
\alias{r.cond.ar2}
\title{Generate Random AR(2) Time Series}
\usage{
r.cond.ar2(N,nj,r.phi1,r.phi2,r.sig2)
}
\arguments{
\item{N}{Length of the series}

\item{nj}{Number of series generated.}

\item{r.phi1}{Range of first AR order coefficient. It is a vector contains minimum and maximum possible coefficients.}

\item{r.phi2}{Range of second AR order coefficient. It is a vector contains minimum and maximum possible coefficients.}

\item{r.sig2}{Range of conditional innovation variances. It is a vector contains minimum and maximum possible variances.}
}
\value{
a list with 2 elements
\item{X}{\emph{N} by \emph{nj} matrix of time series}
\item{cep}{3 by \emph{nj} matrix of parameters (phi1, phi2, sig2)}
}
\description{
Simulates multiple AR(2) time series.
}
\examples{
## Simulate data
nj = 50  #number of series in training data
N = 500  #length of time series
data1 <- r.cond.ar2(N=N,nj=nj,r.phi1=c(.01,.7),r.phi2=c(-.12,-.06),r.sig2=c(.3,3))
data2 <- r.cond.ar2(N=N,nj=nj,r.phi1=c(.5,1.2),r.phi2=c(-.36,-.25),r.sig2=c(.3,3))
data3 <- r.cond.ar2(N=N,nj=nj,r.phi1=c(.9,1.5),r.phi2=c(-.56,-.75),r.sig2=c(.3,3))
data <- cbind(data1$X,data2$X,data3$X)
y <- c(rep(1,nj),rep(2,nj),rep(3,nj))  
}
\author{
Robert Krafty \email{<rkrafty@pitt.edu>}
}
\references{
Krafty, RT (2016) Discriminant Analysis of Time Series in the Presence of Within-Group Spectral Variability.  \emph{Journal of Time series analysis}
}
\seealso{
\code{\link{cep.lda}}
}

