% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkHostParams.R
\name{checkLicenseFile}
\alias{checkLicenseFile}
\title{Checks if NLME run is licensed}
\usage{
checkLicenseFile(installDir, licenseFile = "", verbose = FALSE)
}
\arguments{
\item{installDir}{Directory with NLME executables as specified in \code{INSTALLDIR} environment variable.}

\item{licenseFile}{Path to the license file. If not given, and Gemalto License
server is not active, NLME will try to look for it in \code{installationDirectory},
and in Phoenix installation directory.}

\item{verbose}{Flag to output warnings if issues are found.}
}
\value{
\code{TRUE} if all checks are successful, otherwise \code{FALSE}.
}
\description{
Checks if valid license file is available for NLME run.
}
\examples{
\dontrun{
checkLicenseFile(Sys.getenv("INSTALLDIR"), FALSE)
}

}
