% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableParams.R
\name{tableParams}
\alias{tableParams}
\title{Wrapper around NlmeTableDef/NlmeSimTableDef-classes initializers.}
\usage{
tableParams(
  name = "",
  timesList = numeric(0),
  covrSet = "",
  whenDose = "",
  whenObs = "",
  variablesList = "",
  keepSource = FALSE,
  timeAfterDose = FALSE,
  IRES = FALSE,
  Weight = FALSE,
  IWRES = FALSE,
  mode = "all",
  forSimulation = FALSE
)
}
\arguments{
\item{name}{Name of the generated simulation file.}

\item{timesList}{Numeric; Time values for simulation.
Applicable for time-based models only. Ignored when \code{"keepSource=TRUE"}}

\item{covrSet}{Character; Vector of covariate names. Simulation point is added
when the covariate value is set. See \code{\link{covariateNames}}}

\item{whenDose}{Character; Vector of dosing compartment names.
Simulation point is added when the dose value is set.}

\item{whenObs}{Character; String of observed variables names.
Simulation point is added when the observation value is set.}

\item{variablesList}{Character; List of variables from the model for simulation.}

\item{keepSource}{Logical; Set to \code{TRUE} to keep the number of rows appearing
in the table the same as the number of rows in the input dataset.}

\item{timeAfterDose}{Set to \code{TRUE} to output time after dose.}

\item{IRES}{Logical; Set to \code{TRUE} to output individual residuals.
Valid only if whenObs is specified.}

\item{Weight}{Logical; Set to \code{TRUE} to output the weight of current observation.
Valid only if whenObs is specified.}

\item{IWRES}{Logical; Set to \code{TRUE} to output individual weighted residuals.
Valid only if whenObs is specified.}

\item{mode}{Character; The mode of output. Options are \code{"all"} (default),
\code{"unique"}, \code{"first"}.
Only applicable to non time-based models for the case where only \code{covrSet}
is defined or the case where only \code{covrSet} and \code{variablesList} are defined.

Option \code{"all"} (default): it outputs all the rows invoked by specified covariates.
Option \code{"unique"}: if the values in a row are the same as the ones
in the previous row for the current subject, then the row is omitted; otherwise, it is printed out.
Option \code{"first"}: it outputs only the first row for each subject.}

\item{forSimulation}{logical. Defining whether the table is for simulation
purposes or for postprocessing after fit. Default is \code{FALSE}.}
}
\value{
\code{NlmeTableDef} object if \code{forSimulation} is \code{FALSE},
\code{NlmeSimTableDef} object otherwise.
}
\description{
Wrapper around NlmeTableDef/NlmeSimTableDef-classes initializers.
}
\examples{
Table1 <- tableParams(
  name = "Table1.csv",
  timesList = seq(0, 24, 2),
  whenObs = c("CObs"),
  variablesList = "C",
  IRES = TRUE,
  IWRES = TRUE,
  Weight = TRUE)

SimTable1 <- tableParams(
  name = "SimTable1.csv",
  variablesList = "CL, V",
  keepSource = TRUE,
  forSimulation = TRUE)

}
