% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqa_plot.R
\name{plot.chaos01.rqa.sequence}
\alias{plot.chaos01.rqa.sequence}
\title{Plot the results for the sequence of eps values.}
\usage{
\method{plot}{chaos01.rqa.sequence}(x, plotvar = c("RR", "DET"),
  type = NULL, ...)
}
\arguments{
\item{x}{the object of "rqa.sequence" class, produced by rqa.seq function.}

\item{plotvar}{vector/list of strings of variables which should be plotted.
\itemize{
    \item "TR"    - Total number of recurrence points
    \item "DLRP"  - Recurrence points on the diagonal lines of length of length >= lmin
    \item "DLC"   - Count of diagonal lines of length of length >= lmin
    \item "VLRP"  - Recurrence points on the vertical lines of length of length >= lmin
    \item "VLC"   - Count of vertical lines of length of length >= lmin
    \item "RR"    - Recurrence rate
    \item "DET"   - Determinism, count recurrence points in diagonal lines of length >= lmin 
    \item "RATIO" - DET/RR
    \item "AVG"   - average length of diagonal lines of length >= lmin
    \item "MAX"   - maximal length of diagonal lines of length >= lmin
    \item "LAM"   - Laminarity, VLRP/TR
    \item "TT"    - Trapping time, average length of vertical lines of length >= lmin
    \item "MAX_V" - maximal length of vertical lines of length >= lmin
    \item "DIV"   - Divergence, 1/MAX
}

Default = c("RR", DET").}

\item{type}{string what type of plot should be drawn: see\code{\link[graphics]{plot}}}

\item{...}{arguments to be passed as graphical parameters.}
}
\description{
This function plot the selected variables of RQA as a sequence for the different values of epsilon.
}
\examples{
vec.x <- gen.logistic(mu = 3.55, iter = 2000)

x.range <- diff(range(vec.x))

from = 0.01 * x.range
by   = 0.1 * x.range

# Output for each value of c
res <- rqa.seq(vec.x, from = from, to = x.range, by = by, TS = vec.x, dim = 3, lag = 10)

plotvar <- c("RR", "DET", "RATIO", "LAM")

par(mfrow = c(2,2))
plot(res, plotvar = plotvar)
}
\references{
N. Marwan; M. C. Romano; M. Thiel; J. Kurths (2007). "Recurrence Plots for the Analysis of Complex Systems". Physics Reports. 438 (5-6): 237. Bibcode:2007PhR...438..237M. doi:10.1016/j.physrep.2006.11.001.
}
\seealso{
\code{\link{rqa.seq}}, \code{\link{fast.rqa}}
}
\keyword{plot}
\keyword{rqa}
\keyword{threshold}
