% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeGroup.R, R/removeSample.R
\name{removeGroup}
\alias{removeGroup}
\alias{removeSample}
\title{Remove Groups or Samples from a Spectra Object}
\usage{
removeGroup(spectra, rem.group)

removeSample(spectra, rem.sam)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra}}.}

\item{rem.group}{A character vector giving the groups to be removed.}

\item{rem.sam}{Either an integer vector specifying the samples to be
removed, or a character vector giving the sample names to be removed.}
}
\value{
A modified object of S3 class \code{\link{Spectra}}.
}
\description{
Removes specified groups or samples from a \code{\link{Spectra}} object.
}
\details{
Both functions will report if extra data elements are found.  These will
probably need to be edited manually.  The indices reported to the console
can be helpful in this regard.

If \code{rem.sam} is a character vector, the sample
names are grepped for the corresponding values.  \code{rem.group}
also uses grep.  Remember that the
grepping process is greedy, i.e. grepping for "XY" find not only "XY" but
also "XYZ".

Unused levels in \code{$groups} are dropped.
}
\section{Functions}{
\itemize{
\item \code{removeGroup}: Remove groups from a \code{Spectra} object

\item \code{removeSample}: Remove samples from a \code{Spectra} object
}}
\examples{

data(metMUD1)

# removeGroup
sumSpectra(metMUD1)
trmt <- removeGroup(metMUD1, rem.group = "Cntrl")
sumSpectra(trmt)

# removeSample
# Removes the 20th spectrum/sample:
new1 <- removeSample(metMUD1, rem.sam = 20)

# Removes one spectrum/sample with this exact name:
new2 <- removeSample(metMUD1, rem.sam = "Sample_20")

# Opps! Removes all samples due to greedy grep!
new3 <- removeSample(metMUD1, rem.sam = "Sample")

}
\author{
Bryan A. Hanson, DePauw University.
}
\references{
\url{https://github.com/bryanhanson/ChemoSpec}
}
\seealso{
\code{\link{removeFreq}} to remove selected frequencies.
}
\keyword{manip}
\keyword{utilities}

