% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumGroups.R
\name{sumGroups}
\alias{sumGroups}
\title{Summarize the Group Parameters of a Spectra Object}
\usage{
sumGroups(spectra)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra}} whose group
membership information is desired.}
}
\value{
A data frame as follows.  Note that if there are groups with no
members (due to previous use of \code{\link{removeSample}}), these are
dropped.  \item{group}{The name of the group.} \item{no.}{The number in the
group.} \item{color}{The color assigned to the group.} \item{symbol}{The
symbol assigned to the group.} \item{alt.symbol}{The alternative symbol, a
lower-case letter, assigned to the group.}
}
\description{
This function summarizes the group membership and descriptive parameters of
a \code{\link{Spectra}} object.
}
\examples{

data(metMUD1)
sumGroups(metMUD1)

}
\author{
Bryan A. Hanson, DePauw University.
}
\references{
\url{https://github.com/bryanhanson/ChemoSpec}
}
\seealso{
For a discussion of general issues of color, see
\code{\link{colorSymbol}}.  To summarize the entire object, \code{\link{sumSpectra}}.
}
\keyword{utilities}

