% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check4Gaps.R
\name{check4Gaps}
\alias{check4Gaps}
\title{Check for Discontinuities (Gaps) in a Vector & Optionally Make a Plot}
\usage{
check4Gaps(x, y = NULL, silent = FALSE, tol = NULL, ...)
}
\arguments{
\item{x}{A numeric vector to be checked for gaps.}

\item{y}{An optional vector of \code{y}-values which correspond to the \code{x}
values.  Only used in \code{ChemoSpec}.  If provided, a plot will be made
in the style of a \code{\link[ChemoSpec]{Spectra}} object showing the gap(s).}

\item{silent}{Logical indicating a "no gap" message
should not be reported to the console.  Important because
\code{check4Gaps} is called iteratively by other functions.}

\item{tol}{A number indicating the tolerance for checking to see if the step
between successive \code{x} values are the same.  Depending upon how the
\code{x} values are stored and rounded, you may need to change the value of
\code{tol} to avoid flagging trivial "gaps".  If \code{NULL}, a value is
chosen which is just above the median difference between \code{x} values.}

\item{\dots}{Other parameters to be passed to the plot routines if
\code{y} is provided, e.g. \code{xlim}.}
}
\value{
A data frame giving the data chunks found, with one chunk per row.
Also a plot if \code{y} is provided.  In the event there are no gaps found,
a data frame with one row is returned.  The data frame has columns as follows:
\item{beg.freq }{The first frequency value in a given data chunk.}
\item{end.freq }{The last frequency value in a given data chunk.}
\item{size }{The length (in frequency units) of the data chunk.}
\item{beg.indx }{The index of the first frequency value in the data chunk.}
\item{end.indx }{The index of the last frequency value in the data chunk.}
}
\description{
The basic procedure is to compare \code{x[n + 1] - x[n]} for successive values of
n.  When this value jumps, there is a gap which is flagged. \code{beg.indx}
and \code{end.indx} will always be contiguous as indices must be; it is the
\code{x} values that jump or have the gap.  The indices are provided as they
are more convenient in some programming contexts.  If not assigned, the
result appears at the console.
}
\examples{

x <- seq(0, 2 * pi, 0.1)
y <- sin(x)
remove <- c(8:11, 40:45)
x <- x[-remove]
y <- y[-remove]
gaps <- check4Gaps(x, tol = 0.11) # tol just larger than orig spacing
gaps
gaps <- check4Gaps(x, y, tol = 0.11) # show a plot if y given

}
\seealso{
\code{\link{sumSpectra}} which make extensive use of this function.
}
\author{
Bryan A. Hanson (DePauw University).
}
\keyword{utilities}
