% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChineseNames.R
\name{compute_name_index}
\alias{compute_name_index}
\title{Compute multiple features of surnames and given names.}
\usage{
compute_name_index(
  data = NULL,
  var.fullname = NULL,
  var.surname = NULL,
  var.givenname = NULL,
  var.birthyear = NULL,
  name = NA,
  birth = NA,
  index = c("NLen", "SNU", "SNI", "NU", "CCU", "NG", "NV", "NW", "NC"),
  NU.approx = TRUE,
  digits = 4,
  return.namechar = TRUE,
  return.all = FALSE
)
}
\arguments{
\item{data}{Data frame.}

\item{var.fullname}{Variable name of Chinese full names (e.g., \code{"name"}).}

\item{var.surname}{Variable name of Chinese surnames (e.g., \code{"surname"}).}

\item{var.givenname}{Variable name of Chinese given names (e.g., \code{"givenname"}).}

\item{var.birthyear}{Variable name of birth year (e.g., \code{"birth"}).}

\item{name}{If no \code{data}, you can just input a vector of full name(s).}

\item{birth}{If no \code{data}, you can just input a vector of birth year(s).}

\item{index}{Which indices to compute?

By default, it computes all available name indices:
\itemize{
  \item \code{NLen}: full-name length (2~4).
  \item \code{SNU}: surname uniqueness (1~6).
  \item \code{SNI}: surname initial (1~26).
  \item \code{NU}: name-character uniqueness (1~6).
  \item \code{CCU}: character-corpus uniqueness (1~6).
  \item \code{NG}: name gender (-1~1).
  \item \code{NV}: name valence (1~5).
  \item \code{NW}: name warmth (1~5).
  \item \code{NC}: name competence (1~5).
}

For details, see \url{https://github.com/psychbruce/ChineseNames}}

\item{NU.approx}{Whether to \emph{approximately} compute name-character uniqueness (NU)
using \emph{the nearest two birth cohorts with relative weights}
(which would be more precise than just using a single birth cohort).
Default is \code{TRUE}.}

\item{digits}{Number of decimal places. Default is \code{4}.}

\item{return.namechar}{Whether to return separate name characters.
Default is \code{TRUE}.}

\item{return.all}{Whether to return all temporary variables
in the computation of the final variables.
Default is \code{FALSE}.}
}
\value{
A new data frame (of class \code{data.table}) with name indices appended.
Full names are split into \code{name0} (surnames, with compound surnames automatically detected),
\code{name1}, \code{name2}, and \code{name3} (given-name characters).
}
\description{
Compute all available name features (indices) based on
\code{\link{familyname}} and \code{\link{givenname}}.
You can either input a data frame
with a variable of Chinese full names
(and a variable of birth years, if necessary)
or just input a vector of full names
(and a vector of birth years, if necessary).

\itemize{
  \item Usage 1: Input a single value or a vector of \code{name} [and \code{birth}, if necessary].
  \item Usage 2: Input a data frame of \code{data}
  and the variable name of
  \code{var.fullname} (or \code{var.surname} and/or \code{var.givenname})
  [and \code{var.birthyear}, if necessary].
}

\emph{Caution.} Name-character uniqueness (NU) for birth year >= 2010
is estimated by forecasting and thereby may not be accurate.
}
\note{
For details and examples, see \url{https://github.com/psychbruce/ChineseNames}
}
\section{Citation}{

Bao, H.-W.-S. (2021). ChineseNames: Chinese Name Database 1930-2008.
R package version 1.1.1.
\url{https://CRAN.R-project.org/package=ChineseNames}

Bao, H.-W.-S., Cai, H., Jing, Y., & Wang, J. (2021).
Novel evidence for the increasing prevalence of unique names in China:
A reply to Ogihara (2020). \emph{Frontiers in Psychology, 12}, 731244.
\url{https://www.frontiersin.org/articles/10.3389/fpsyg.2021.731244/full}
}

\examples{
## Prepare ##
sn=familyname$surname[1:12]
gn=c(top100name.year$name.all.1960[1:6],
     top100name.year$name.all.2000[1:6],
     top100name.year$name.all.1960[95:100],
     top100name.year$name.all.2000[95:100])
demodata=data.frame(name=paste0(sn, gn),
                    birth=c(1960:1965, 2000:2005,
                            1960:1965, 2000:2005))
# View(demodata)

## Compute ##
newdata=compute_name_index(demodata,
                           var.fullname="name",
                           var.birthyear="birth")
# View(newdata)

}
