% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MorphospacePlot.R
\name{MorphospacePlot}
\alias{MorphospacePlot}
\title{Plot Morphopace}
\usage{
MorphospacePlot(pcoa_input, x_axis = 1, y_axis = 2, z_axis = NULL,
  plot_taxon_names = FALSE, plot_internal_nodes = FALSE,
  plot_root = TRUE, root_colour = "grey")
}
\arguments{
\item{pcoa_input}{The main input in the format output from \link{MorphMatrix2PCoA}.}

\item{x_axis}{Which ordination axis to plot as the x-axis (defaults to 1).}

\item{y_axis}{Which ordination axis to plot as the y-axis (defaults to 2).}

\item{z_axis}{Which ordination axis to plot as the z-axis (defaults to NULL, i.e., is not plotted).}

\item{plot_taxon_names}{Optional to plot the names of the taxa (defaults to FALSE).}

\item{plot_internal_nodes}{Optional to plot the internal nodes of the tree (if included in \code{pcoa_input}) (defaults to FALSE).}

\item{plot_root}{Optional to plot the root separately (defaults to FALSE).}

\item{root_colour}{If plotting the root separately (previous option) sets the root colour.}
}
\description{
Plots a morphospace using the output from MorphMatrix2PCoA.
}
\details{
Uses output from \link{MorphMatrix2PCoA} as input.

Allows plotting of a third axis using the technique of Matthew Wills (Wills et al. 1994; their Figures 4 and 8; Wills 1998; his Figure 4), where black and white indicate positive and negative values respectovely, and the size of points there magnitudes.
}
\examples{

# Set random seed:
set.seed(4)

# Generate a random tree for the Michaux 1989 data set:
tree <- rtree(length(rownames(Michaux1989$Matrix_1$Matrix)))

# Add taxon names to the tree:
tree$tip.label <- rownames(Michaux1989$Matrix_1$Matrix)

# Perform a phylogenetic Principal Coordinates Analysis:
pcoa_input <- MorphMatrix2PCoA(Michaux1989, Tree = tree)

# Plot the results:
MorphospacePlot(pcoa_input, plot_taxon_names = TRUE)

}
\references{
Wills, M. A., 1998. Cambrian and Recent disparity: the picture from priapulids. Paleobiology, 24, 177-199.

Wills, M. A., Briggs, D. E. G. and Fortey, R. A., 1994. Disparity as an evolutionary index: a comparison of Cambrian and Recent arthropods. Paleobiology, 20, 93-130.
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com} and Emma Sherratt \email{emma.sherratt@gmail.com}
}
