% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/giniindex.R
\name{giniindex}
\alias{giniindex}
\title{Gini index}
\usage{
giniindex(E, d, Rule)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims.}

\item{Rule}{A rule: AA, APRO, CE, CEA, CEL, DT, MO, PIN, PRO, RA, Talmud.}
}
\value{
The Gini index of a rule for a claims problem and the Gini index of the vector of claims.
}
\description{
This function returns the Gini index of a rule for a claims problem.
}
\details{
Let \eqn{E> 0} be the endowment to be divided and \eqn{d\in \mathcal{R}^n}{d} the vector of claims
with \eqn{d\ge 0} and such that \eqn{D=\sum_{i=1}^{n} d_i\ge E}{D=\sum di \ge E}, the sum of claims \eqn{D} exceeds the endowment.

Rearrange the claims from small to large, \eqn{0 \le d_1 \le...\le d_n}{%
0 \le d1 \le...\le dn}. The Gini index is a number aimed at measuring the degree of inequality in a distribution.
The Gini index of the rule \eqn{R} for the problem \eqn{(E,d)}, denoted by \eqn{G(R,E,d)}, is
the ratio of the area that lies between the identity line and the Lorenz curve of the rule over the total area under the identity line.

Let \eqn{R_0(E,d)=0}{R0(E,d)=0}. For each \eqn{k=0,\dots,n} define
\eqn{X_k=\frac{k}{n}}{Xk=k/n} and
\eqn{Y_k=\frac{1}{E} \sum_{j=0}^{k} R_j(E,d)}{Yk=(R0+\dots+Rk)/E}. Then
\deqn{G(R,E,d)=1-\sum_{k=1}^{n}(X_{k}-X_{k-1})(Y_{k}+Y_{k-1}).}{G(R,E,d)=1-\sum (Xk-X(k-1))(Yk+Y(k-1) where the sum goes from k=1 to n.}
In general \eqn{0\le G(R,E,d) \le 1}.
}
\examples{
E=10
d=c(2,4,7,8)
Rule=AA
giniindex(E,d,Rule)
# The Gini index of the proportional awards coincides with the Gini index of the vector of claims
giniindex(E,d,PRO)
}
\references{
Ceriani, L. and Verme, P. (2012). The origins of the Gini index: extracts from Variabilitá e Mutabilitá (1912) by Corrado Gini. The Journal of Economic Inequality, 10(3), 421-443.

Mirás Calvo, M.A., Núñez Lugilde, I., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2021). Deviation from proportionality and Lorenz-dominance between
the average of awards and the standard rules for claims problems. Working paper 2021-01, ECOBAS.
}
\seealso{
\link{lorenzcurve}, \link{cumulativecurve}, \link{proportionalityindex}, \link{indexpath}, \link{lorenzdominance}.
}
