% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MO.R
\name{MO}
\alias{MO}
\title{Minimal overlap rule}
\usage{
MO(E, d, name = FALSE)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims.}

\item{name}{A logical value.}
}
\value{
The awards vector selected by the MO rule. If name = TRUE, the name of the function (MO) as a character string.
}
\description{
This function returns the awards vector assigned by the minimal overlap rule rule (MO) to a claims problem.
}
\details{
Let \eqn{E\ge 0} be the endowment to be divided and \eqn{d\in \mathcal{R}^n}{d} the vector of claims
with \eqn{d\ge 0} and such that \eqn{\sum_{i=1}^{n} d_i\ge E,\;}{} the sum of claims exceeds the endowment.

The truncated claim of a claimant \eqn{i} is the minimum of the claim and the endowment:
\deqn{t_i(E,d)=t_i=\min\{d_i,E\},\ i=1,\dots,n}{ti=min\{di,E\}, i=1,\dots,n}

Suppose that each agent claims specific parts of E equal to her/his
claim. After arranging which parts agents claim so as to “minimize
conflict”, equal division prevails among all agents claiming a
specific part and each agent receives the sum of the compensations
she/he gets from the various parts that he claimed.

Let \eqn{d_0=0}{d0=0}. The minimal overlap rule is defined, for each problem \eqn{(E,d)} and each claimant \eqn{i}, as:

If \eqn{E\le d_n} then
\deqn{MO_i(E,d)=\frac{t_1}{n}+\frac{t_2-t_1}{n-1}+\dots+\frac{t_i-t_{i-1}}{n-i+1}.}{%
MOi(E,d) = t1/n + (t2-t1)/(n-1) + \dots + (ti-t(i-1))/(n-i+1).}

If \eqn{E>d_n} let \eqn{s\in (d_k,d_{k+1}]}{dk<s \le d(k+1)}, with \eqn{k\in \{0,1,\dots,n-2\}}{0\le k \le n-2},
be the unique solution to the equation \eqn{\sum_{i \in N} \max\{d_i-s,0\} =E-s}{max\{d1-s,0\}+\dots+max\{dn-s,0\}=E-s}. Then:
\deqn{MO_i(E,d)=\frac{d_1}{n}+\frac{d_2-d_1}{n-1}+\dots+\frac{d_i-d_{i-1}}{n-i+1}, \  i\in\{1,\dots,k\}}{%
MOi(E,d) = d1/n + (d2-d1)/(n-1) + \dots + (di-d(i-1))/(n-i+1), if i\le k}
\deqn{MO_i(E,d)=MO_i(s,d)+d_i-s, \  i\in\{k+1,\dots,n\}.}{MOi(E,d) = MOi(s,d)+di-s,  if  i>k+1.}
}
\examples{
E=10
d=c(2,4,7,8)
MO(E,d)
}
\references{
Mirás Calvo, M.A., Núñez Lugilde, I., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2021). The adjusted proportional and the minimal overlap rules restricted to the lower-half, higher-half, and middle domains. Working paper 2021-02, ECOBAS.

O'Neill, B. (1982). A problem of rights arbitration from the Talmud. Math. Social Sci. 2, 345-371.

Thomson, W. (2019). How to divide when there isn't enough. From Aristotle, the Talmud, and Maimonides to the axiomatics of resource allocation. Cambridge University Press.
}
\seealso{
\link{allrules}, \link{CD}.
}
