% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumawardscurve.R
\name{cumawardscurve}
\alias{cumawardscurve}
\title{Cumulative awards curve}
\usage{
cumawardscurve(E, d, Rule = PRO, Rules, col = NULL, legend = TRUE)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims.}

\item{Rule}{Principal Rule: AA, APRO, CE, CEA, CEL, DT, MO, PIN, PRO, RA, Talmud. By default, Rule = PRO.}

\item{Rules}{The rules: AA, APRO, CE, CEA, CEL, DT, MO, PIN, PRO, RA, Talmud.}

\item{col}{The colours. If col = NULL then the sequence of default colours is:
c("red", "blue", "green", "yellow", "pink", "coral4", "darkgray", "burlywood3", "black", "darkorange", "darkviolet").}

\item{legend}{A logical value. The colour legend is shown if legend = TRUE.}
}
\value{
The graphical representation of the cumulative curves of a rule (or several rules) for a claims problem.
}
\description{
The graphical representation of the cumulative curves of a rule (or several rules) with respect to a given rule, for a claims problem.
}
\details{
Let \eqn{E> 0} be the endowment to be divided and \eqn{d\in \mathcal{R}^n}{d} the vector of claims
with \eqn{d\ge 0} and such that the sum of claims \eqn{D=\sum_{i=1}^{n} d_i\ge E}{D=\sum di} exceeds the endowment.

Rearrange the claims from small to large, \eqn{0 \le d_1 \le...\le d_n}{%
0 \le d1 \le...\le dn}. The cumulative curve allows us
to compare the division recommended by a specific rule \eqn{R} with the division the division recommended by another specific rule \eqn{S}.

The cumulative awards curve of a rule \eqn{S} with respect of a rule \eqn{R} for the claims problem \eqn{(E,d)} is the polygonal path connecting the \eqn{n+1} points
\deqn{(0,0), (\frac{R_1}{E},\frac{S_1}{E}),\dots,(\frac{\sum_{i=1}^{n-1}R_i}{E},\frac{\sum_{i=1}^{n-1}S_i}{E}),(1,1).}{%
(0,0) , (R1/E,S1/E) , ((R1+R2)/E , (S1+S2)/E ,\dots , (1,1).}

The cumulative awards curve fully captures the Lorenz ranking of rules:
if a rule \eqn{R} Lorenz-dominates a rule \eqn{S} then, for each claims problem, the cumulative curve of \eqn{R}
lies above the cumulative curve of \eqn{S}.
If \eqn{R = PRO}, the cumulative curve coincides with the cumulative claims-awards curve.

\eqn{cumulativecurve} function of version 0.1.0 returned the cumulative claims-awards curve with respect to the proportional rule.
}
\examples{
E=10
d=c(2,4,7,8)
Rule=PRO
Rules=c(AA,RA,Talmud,CEA,CEL)
cumawardscurve(E,d,Rule,Rules)
}
\references{
Lorenz, M. O. (1905). Methods of measuring the concentration of wealth. Publications of the American statistical association, 9(70), 209-219.

Mirás Calvo, M.Á., Núñez Lugilde, I., Quinteiro Sandomingo, C., and Sánchez Rodríguez, E. (2022). Deviation from proportionality and Lorenz-domination for claims problems. Rev Econ Design. \doi{10.1007/s10058-022-00300-y}
}
\seealso{
\link{deviationindex}, \link{indexgpath}, \link{lorenzcurve}, \link{giniindex}, \link{lorenzdominance},  \link{allrules}.
}
