% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seed_need.R
\name{seed_need}
\alias{seed_need}
\title{Required seed amount in a tricot project}
\usage{
seed_need(nobservers = 100, ncomp = 3, nitems = 10, nseeds = 0.15, unit = "kg")
}
\arguments{
\item{nobservers}{an integer for the number of observers}

\item{ncomp}{an integer for the number of items each observer compares}

\item{nitems}{an integer for the number of items tested in the project}

\item{nseeds}{an integer for the metric of seeds each bag receives}

\item{unit}{optional, a character specifying the metric unit used}
}
\value{
a dataframe with required number of seeds
}
\description{
Calculate the required amount of seeds (or other technology) required 
for a triadic comparison of technologies (tricot) project.
}
\examples{
  
# allocate 0.2 kg of seeds per variety in a project with 500 
# participants and 14 varieties
seed_need(nobservers = 500,
          ncomp = 3,
          nitems = 14, 
          nseeds = 0.2)

# allocate 100 seedlings per variety in a project with 400 
# participants, 8 varieties and 3 comparisons between varieties
seed_need(nobservers = 400,
          ncomp = 3,
          nitems = 9, 
          nseeds = 100,
          unit = "unit")
}
\author{
Kauê de Sousa
}
