% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.lsmeans.R
\name{report.lsmeans}
\alias{report.lsmeans}
\title{Returns in a pretty format, the LS means of a model
(It's not that fantastic but it's handy)}
\usage{
report.lsmeans(lsm, x1.name = "treatment", x2.name = NULL,
  x3.name = NULL, variable.name = "Statistics", at.row = NULL,
  infer = c(T, T), type = "link")
}
\arguments{
\item{lsm}{an emmGrid object (result of a emmeans call)}

\item{x1.name}{Character indicating a factor in the data. Levels will be displayed in columns}

\item{x2.name}{Character indicating a factor in the data. Levels will be displayed in rows}

\item{x3.name}{Character indicating a factor in the data. Levels will be displayed in rows}

\item{variable.name}{Character. The label of the column which indicates the statistics reported.}

\item{at.row}{Character. Passed to spacetable function. Used to space the results per levels of the mentioned variable}

\item{infer}{pass to summary.emmGrid function. Can be c(T,T) c(T,F) c(F,T) c(F,F) or T or F}

\item{type}{Character. pass to summary.emmGrid function. can be "link" or "response"}
}
\value{
A desc object that can be used for the report.doc function.
}
\description{
Create nice reporting table of lsmeans (or emmeans if you prefer, whatever...).
}
\details{
This function has been created with love and passion.
}
\examples{

library(emmeans)
library(lme4)

data(data)

#Simple lm model

luke=lm(Petal.Width~Species,data=iris)
vador=emmeans(luke,~Species)
report.lsmeans(vador,"Species")

# In case of just one intercept, x1.name="X1"
lucky=glm(Species~1,data=iris,family=binomial)
strike=emmeans(lucky,~1)
report.lsmeans(strike,"X1")

#Mixed model example using lme4

james=lmer(y_numeric~GROUP+TIMEPOINT+GROUP*TIMEPOINT+(1|SUBJID),data=data) 
bond=emmeans(james,~GROUP|TIMEPOINT)
report.lsmeans(lsm=bond,x1.name="GROUP",x2.name="TIMEPOINT",at.row="TIMEPOINT")


}
\seealso{
\code{\link{report.quali}} \code{\link{emmeans}} \code{\link{report.doc}}
}
