% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.quali.R
\name{report.quali}
\alias{report.quali}
\title{Descriptive "Qualitative" statistics (frequencies and percentages) reporting}
\usage{
report.quali(data, y = NULL, x1 = NULL, x2 = NULL, y.label = y,
  x2.label = NULL, y.levels.label = "Levels", total = F, round = 2,
  at.row = NULL, percent.col = T, subjid = NULL, remove.zero = F,
  drop.y = NULL, drop.x1 = NULL, drop.x2 = NULL,
  remove.missing = F)
}
\arguments{
\item{data}{a data.frame object}

\item{y}{Character indicating a factor in the data (the response)}

\item{x1}{Character indicating a factor in the data (levels will be displayed in columns)}

\item{x2}{Character indicating a factor in the data (levels will be displayed in rows). Only possible if x1 is not NULL.}

\item{y.label}{Character indicating the label for y to be displayed in the title of the table}

\item{x2.label}{Character indicating the label for x2 parameter, only if x2 is not null}

\item{y.levels.label}{Character. Indicates the label of the column in which the levels of y are displayed}

\item{total}{Logical Indicates if a column Total should be added or not}

\item{round}{Integer Indicates the number of digits to round percentages}

\item{at.row}{Character. Pass to spacetable function. Used to space the results (see example below)}

\item{percent.col}{Logical By default it is set to T to indicate that column percentages should be reported. If set to False, row percentages are reported.}

\item{subjid}{Character Indicates in the data.frame the name of the column used to identify the Id of the subjects. If not null, it adds in the headers the number of unique subject per levels of x1 or y (if x1 is null).}

\item{remove.zero}{Logical. Remove the levels in the contingency table for which there is no observation.}

\item{drop.y}{Character. Indicates one or several levels of the y factor that you want to drop in the result}

\item{drop.x1}{Character. Indicates one or several levels of the x1 factor that you want to drop in the result}

\item{drop.x2}{Character. Indicates one or several levels of the x2 factor that you want to drop in the result}

\item{remove.missing}{Logical. default to TRUE. If TRUE number of missing values are reported and percentages
take into account the number of missing value in the calculation. If set to FALSE, the missing values regarding the response factor y are ignored
and percentages are computed on non missing values only.}
}
\value{
A desc object
}
\description{
Compute and report frequencies and percentages by levels of \code{y} (in rows) and by levels of \code{x1} (in columns)
and \code{x2} in rows.

For more examples see the website: \href{https://jfrancoiscollin.github.io/ClinReport}{ClinReport website}
}
\details{
This function computes and reports qualitative statistics by level of \code{y} and by level of \code{x1} (if not null)
and \code{x2} (if not null).

See examples to show the results. If \code{total=T}, the last column is the statistics
performed overall levels of the explicative variables x1.

Note that missing values are counted in the calculation of the percentages.
}
\examples{

 
data(datafake)

# No explicative variable changing y labels (option y.levels.label)
report.quali(data=datafake,y="y_logistic",
y.label="Clinical cure",y.levels.label="Levels")

# 1 explicative variable (option x1:  levels in columns)
report.quali(data=datafake,y="y_logistic",x1="GROUP",y.levels.label="Clinical cure")

# 2 explicative variables (x1, levels in columns, option x2, levels in rows),
# spcacing the results (option at.row)
report.quali(data=datafake,y="y_logistic",x1="GROUP",
x2="TIMEPOINT",y.levels.label="Clinical cure",x2.label="Days",at.row="Days")

# 2 explicative variables with row percentages (option percent.col=F)
report.quali(data=datafake,y="y_logistic",x1="GROUP",
x2="TIMEPOINT",percent.col=FALSE,x2.label="Days",y.levels.label="Clinical cure")

# Add Total number of subjects in headers (option subjid="SUBJID")
report.quali(data=datafake,y="y_logistic",x1="GROUP",
x2="TIMEPOINT",at.row="TIMEPOINT",subjid="SUBJID")

# Round percentages to 1 digit (option round=1)
report.quali(data=datafake,y="y_logistic",x1="GROUP",
x2="TIMEPOINT",at.row="TIMEPOINT",subjid="SUBJID",round=1)


# Qualitative statistics with a response with more than one levels
tab=report.quali(data=datafake,y="y_poisson",x1="GROUP",
x2="TIMEPOINT",at.row="TIMEPOINT",subjid="SUBJID",round=1)

# Print formatted results
tab


#Getting raw output (unformatted) 
tab$raw.output
}
\seealso{
\code{\link{report.quanti}}  \code{\link{report.doc}} \code{\link{desc}}
}
