% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusMB.R
\name{ClusMB}
\alias{ClusMB}
\title{Perform a cluster analysis of rows in a Multi-block context with the ClusMB method}
\usage{
ClusMB(Data, Blocks, NameBlocks=NULL, scale=FALSE, center=TRUE,
nclust=NULL, gpmax=6)
}
\arguments{
\item{Data}{data frame or matrix. Correspond to all the blocks of variables merged horizontally}

\item{Blocks}{numerical vector. The number of variables of each block. The sum must be equal to the number of columns of Data.}

\item{NameBlocks}{string vector. Name of each block. Length must be equal to the length of Blocks vector. If NULL, the names are B1,...Bm. Default: NULL}

\item{scale}{logical. Should the data variables be scaled? Default: FALSE}

\item{center}{logical. Should the data variables be centered? Default: TRUE. Please set to FALSE for a CATA experiment}

\item{nclust}{numerical. Number of clusters to consider. If NULL, the Hartigan index advice is taken.}

\item{gpmax}{logical. What is maximum number of clusters to consider? Default: min(6, number of blocks -2)}
}
\value{
\itemize{
         \item group: the clustering partition after consolidation.
         \item nbgH: Advised number of clusters per Hartigan index
         \item nbgCH: Advised number of clusters per Calinski-Harabasz index
         \item cutree_k: the partition obtained by cutting the dendrogram in K clusters (before consolidation).
         \item dend: The ClusMB dendrogram
         \item param: parameters called
         \item type: parameter passed to other functions
         }
}
\description{
Clustering of rows (products in sensory analysis) in a Multi-block context.
The hierarchical clustering is followed by a partitioning algorithm (consolidation).
}
\examples{

#####projective mapping####
library(ClustBlock)
data(smoo)
res1=ClusMB(smoo, rep(2,24))
summary(res1)
indicesClusters(smoo, rep(2,24), res1$group)

####CATA####
data(fish)
Data=fish[1:66,2:30]
chang2=change_cata_format2(Data, nprod= 6, nattr= 27, nsub = 11, nsess= 1)
res2=ClusMB(Data= chang2$Datafinal, Blocks= rep(27, 11), center=FALSE)
indicesClusters(Data= chang2$Datafinal, Blocks= rep(27, 11),cut = res2$group, center=FALSE)

}
\references{
Llobell, F., Qannari, E.M. (June 10, 2022). Cluster analysis in a multi-bloc setting. SMTDA, Athens, Greece.\cr
Llobell, F., Giacalone, D., Qannari, E. M. (Pangborn 2021). Cluster Analysis of products in CATA experiments.\cr
Paper submitted
}
\seealso{
\code{\link{indicesClusters}}, \code{\link{summary.clusRows}} , \code{\link{clustRowsOnStatisAxes}}
}
\keyword{CATA}
\keyword{RATA}
\keyword{quantitative}
