% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choicealpha.R
\name{choicealpha}
\alias{choicealpha}
\title{Empirical choice of the mixing parameter}
\usage{
choicealpha(D0, D1, range.alpha, K, wt = NULL, scale = TRUE, graph = TRUE)
}
\arguments{
\item{D0}{an object of class "dist" with the dissimilarities between the n observations. 
The function \code{\link{as.dist}} can be used to transform an object of class matrix to object of class "dist".}

\item{D1}{an object of class "dist" with other dissimilarities between the same n observations.}

\item{range.alpha}{a vector of real values between 0 and 1.}

\item{K}{the  number of clusters.}

\item{wt}{vector with the weights of the observations. By default, wt=NULL corresponds to
the case where all observations are weighted by 1/n.}

\item{scale}{if TRUE the two dissimilarity matrix are scaled i.e. divided by their max.}

\item{graph}{if TRUE the two graphics (proportion and normalized proportion of explained inertia) are drawn.}
}
\description{
This function calculates the proportion (resp. normalized proportion) of explained inertia of
 the partitions in K clusters obtained with the Ward-like \code{hclustgeo} procedure for a range 
 of mixing parameters alpha. When the proportion (resp. normalized proportion) of explained inertia based on D0 decreases,
  the proportion (resp. normalized proportion)
 of explained inertia based on D1 increases. The plot of these criteria can help the user in the choice of the
 mixing parameter alpha.
}
\examples{
data(estuary)
D0 <- dist(estuary$dat) # the socio-demographic distances
D1 <- as.dist(estuary$D.geo) # the geographic distances between the cities
range.alpha <- seq(0,1,0.1)
K <- 5
cr <- choicealpha(D0,D1,range.alpha,K,graph=TRUE)
cr$Q # proportion of explained pseudo inertia
cr$Qnorm # normalized proportion of explained pseudo inertia
}
\references{
M.chavent, V. Kuentz-Simonet, A. Labenne, J. Saracco.  ClustGeo:  an R package 
for hierarchical clustering with spatial constraints	arXiv:1707.03897 [stat.CO]
}

