% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ClustMMDD.R
\name{EmOptions}
\alias{EmOptions}
\title{Display the current Expectation and Maximization options.}
\usage{
EmOptions()
}
\value{
A list of EM options :
	\itemize{
		\item{epsi : }{The upper bound of the relative increasing on log-likelihood.}
		\item{nberSmallEM : }{The number of random parameter points from which to run small EMs. The estimated parameter point associated to the higher maximum log-likelihood is then used to initialise the final EM run.}
		\item{nberIterations : }{The number of iterations in each small EM.}
		\item{typeSmallEM : }{0 = classic EM, 1 = SEM and 2 = CEM.}
		\item{typeEM : }{0 = classic EM, 1 = SEM and 2 = CEM.}
		\item{nberMaxIterations : }{The maximum number of iterations in the final EM if the convergence is slow.}
		\item{putThreshold : }{The indication of whether all parameter estimates are positive.}
	}
}
\description{
Display the Expectation and Maximization algorithm current options.
}

\examples{
EmOptions()
setEmOptions(list(epsi = 1e-6))
EmOptions()
setEmOptions()	# To set default values
EmOptions()
}
\author{
Wilson Toussile.
}
\references{
\itemize{
		\item  \href{http://projecteuclid.org/euclid.ejs/1379596773}{Dominique Bontemps and Wilson Toussile (2013)} : Clustering and 	variable selection for categorical multivariate data. Electronic Journal of Statistics, Volume 7, 2344-2371, ISSN.
		
		\item 	\href{http://link.springer.com/article/10.1007\%2Fs11634-009-0043-x}{Wilson Toussile and Elisabeth Gassiat (2009)} : Variable 	selection in model-based clustering using multilocus genotype data. Adv Data Anal Classif, Vol 3, number 2, 109-134.
	}
}
\seealso{
\code{\link{setEmOptions}} for setting EM options.
}
\keyword{CEM}
\keyword{EM}
\keyword{SEM}

