% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterscore.R
\name{clusterscore}
\alias{clusterscore}
\title{Calculates de synthetic variable of a cluster}
\usage{
clusterscore(Z)
}
\arguments{
\item{Z}{a centered and reduced data matrix obtained with the recod function}
}
\value{
\item{f}{the synthetic variables i.e. the scores on the first principal component of PCAmix}

\item{sv}{the standard deviation of f i.e. the first singular value}

\item{v}{the standardized loadings}
}
\description{
Calculates the synthetic variable of a cluster of variables.
The variables can be quantitative or qualitative. The synthetic variable is the first principal component of PCAmix.
The variance of the synthetic variable is the first eigenvalue. It is equal to the sum of 
squared correlations or correlation ratios to the synthetic variable. It measures the homogeneity of the cluster.
}
\examples{
data(decathlon)
A <- 1:5
Z <- PCAmixdata::recod(X.quanti=decathlon[1:10,A], X.quali=NULL)$Z
clusterscore(Z)
Z\%*\%as.matrix(clusterscore(Z)$v)
clusterscore(Z)$f
}
