% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimate_Param_FBM.R
\name{Estimate_Param_FBM}
\alias{Estimate_Param_FBM}
\title{Estimating Parameters of EstParmFunc_FBM}
\usage{
Estimate_Param_FBM(
  tau,
  ridge.final,
  Iter.EstParmFunc = 80,
  especie,
  EspecieMaxima,
  Tt,
  E,
  seed = NULL
)
}
\arguments{
\item{tau}{Number. Value of the tau parameter.}

\item{ridge.final}{Object of class "ridgelm". Values obtained with the ridge regression.}

\item{Iter.EstParmFunc}{Number. Number of iterations. Default: 80 iterations.}

\item{especie}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points. The bacteria placed in the last row of the matrix will be used as reference in the alr transformation and will be at the denominator of the balance.}

\item{EspecieMaxima}{Row in which the bacteria chosen as reference is in \code{especie}. This is the bacteria that is going to be at the denominator of the balance and in the deniminator of the alr tranformation. As a result, in this function, \code{EspecieMaxima} must be equal to \code{E}.}

\item{Tt}{Number of time points available}

\item{E}{Number. Number of bacteria available.}

\item{seed}{Number. Set a seed. Default \code{seed=NULL}.}
}
\value{
Returns a list with:
\itemize{
  \item All.iter:  Matrix. Each row has the parameters obtained in each iteration. The parameters are in the columns written in following order: a11,a12,a13, a21, a22,a23, ...a(D-1)1,a(D-1)2,a(D-1)3,tau. Where D is the number of bacterial species present in the matrix \code{especie}. In this matrix we must observe that in the last iterations the values has really similar or equal values, it not, we need to increase the value of \code{Iter.EstParmFunc}.
  \item Param.Estimates:  Vector with the estimated parameters, in the following order: a11,a12,a13, a21, a22,a23, ...a(D-1)1,a(D-1)2,a(D-1)3,tau. Where D is the number of bacterial species present in the matrix \code{especie}.
  \item AIC Number: Value of the AIC.
  }
}
\description{
This function estimates the parameters of the FBM model.
}
\details{
Maximum likelihood estimation is used. This function makes an iterative process, for a given
value of tau, it obtains the value of the rest of the parameters that maximize the dirichlet loglikelihood
(defined in EstParmFunc_FBM) using the Nelder-Mead method and the values obtained in the ridge regression as initial parameters.
Then it uses the values obtained as initial parameters and repeats the process \code{Iter.EstParmFunc} times.

The regression of this model is defined by


\deqn{\mu_{it}=a_{i1}+a_{i2}\cdot\text{alr}(x_{i,(t-1)})+a_{i3}\cdot\text{Balance}(x_{i,(t-1)})\text{ for }i=1,\dots, D-1\text{ where } D \text{ is the number of bacteria}}
}
\examples{

set.seed(123)
especie=t(gtools::rdirichlet(5,c(1,3,1)))
Tt=5
E=3
EspecieMaxima=3
ridge.final=ridgeregression(Tt,especie, E, EspecieMaxima)
tau=20
Iter.EstParmFunc=40

Estimate_Param_FBM(tau,ridge.final,Iter.EstParmFunc, especie,EspecieMaxima,Tt,E, 714)

}
\references{
Creus-Martí, I., Moya, A., Santonja, F. J. (2021). A Dirichlet autoregressive model for the analysis of microbiota time-series data. Complexity, 2021, 1-16.
}
