% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PBmodel.R
\name{PBmodel}
\alias{PBmodel}
\title{Obtaining the regression value of the BPBM}
\usage{
PBmodel(A, MatrizPBmodelo, E, Tt)
}
\arguments{
\item{A}{Matrix that contains all the parameters of the model. The parameters are written in the matrix in the following order (in an example with three bacteria):

   \tabular{rrrrr}{
 a10 \tab  a11  \tab  a12\tab ...\tab  a1M \cr
 a20 \tab  a21  \tab  a22\tab ...\tab  a2M \cr
 a30 \tab  a31  \tab  a32\tab ...\tab  a3M}}

\item{MatrizPBmodelo}{Matrix. Output of "ObtainingValueSPBal" called "MatrixSPBal".}

\item{E}{Number of bacteria in the dataset.}

\item{Tt}{Number of time points.}
}
\value{
Returns a matrix. The row i contains the regression values of the bacteria i at all time points.
}
\description{
This function calculates the value of the BPBM regression, defined by:  \deqn{\mu_{it}=a_{i0}+a_{i1}\cdot\text{SPBal}_{1,t-1}+\cdots+a_{iM}\cdot\text{SPBal}_{M,t-1}}
}
\examples{

A=rbind(c(1,2,3),c(4,5,6),c(7,8,9))
MatrizPBmodelo=cbind(c(1,2,3),c(4,5,6),c(7,8,9))
E=3
Tt=3


PBmodel(A,MatrizPBmodelo, E,Tt)
}
\references{
Creus-Martí, I., Moya, A., Santonja, F. J. (2022). Bayesian hierarchical compositional models for analysing longitudinal abundance data from microbiome studies. Complexity, 2022.
}
