% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateMTS.r
\name{generateMTS}
\alias{generateMTS}
\title{Simulation of multiple time series with given marginals and spatiotemporal properties}
\usage{
generateMTS(n, STmodel)
}
\arguments{
\item{n}{number of fields (time steps) to simulate}

\item{STmodel}{list of arguments resulting from 'fitVAR' function}
}
\description{
Generates multiple time series with given marginals and spatiotemporal properties, just provide (1) the output of 'fitVAR' function, and (2) the number of time steps to simulate
}
\details{
Referring to the documentation of \code{\link{fitVAR}} for details on
computational complexity of the fitting algorithm, here we report indicative
simulation CPU times for some settings, assuming that the model parameters are
already evaluated.
CPU times refer to a Windows 10 Pro x64 laptop with
Intel(R) Core(TM) i7-6700HQ CPU @ 2.60GHz, 4-core, 8 logical processors, and 32GB RAM. \cr
CPU time:\cr
d = 900, p = 1, n = 1000: ~17s \cr
d = 900, p = 1, n = 10000: ~75s \cr
d = 900, p = 5, n = 100: ~280s \cr
d = 900, p = 5, n = 1000: ~302s \cr
d = 2500, p = 1, n = 1000 : ~160s \cr
d = 2500, p = 1, n = 10000 : ~570s
where d denotes the number of spatial locations
}
\examples{
## Simulation of a 4-dimensional vector with VAR(1) correlation structure
coord <- cbind(runif(4)*30, runif(4)*30)

fit <- fitVAR(
  spacepoints = coord,
  p = 1,
  margdist ='burrXII',
  margarg = list(scale = 3,
                 shape1 = .9,
                 shape2 = .2),
  p0 = 0.8,
  stcsid = "clayton",
  stcsarg = list(scfid = "weibull",
                 tcfid = "weibull",
                 copulaarg = 2,
                 scfarg = list(scale = 20,
                               shape = 0.7),
                 tcfarg = list(scale = 1.1,
                               shape = 0.8))
)

sim <- generateMTS(n = 100,
                     STmodel = fit)

}
