% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctmaFit.R
\name{ctmaFit}
\alias{ctmaFit}
\title{ctmaFit}
\usage{
ctmaFit(
  activateRPB = FALSE,
  activeDirectory = NULL,
  allInvModel = FALSE,
  binaries = NULL,
  catsToCompare = NULL,
  chains = NULL,
  cint = 0,
  cluster = NULL,
  coresToUse = c(2),
  CoTiMAStanctArgs = NULL,
  ctmaInitFit = NULL,
  customPar = FALSE,
  digits = 4,
  drift = NULL,
  driftsToCompare = NULL,
  equalDrift = NULL,
  finishsamples = NULL,
  fit = TRUE,
  ind.mod.names = NULL,
  ind.mod.number = NULL,
  ind.mod.type = "cont",
  indVarying = FALSE,
  indVaryingT0 = NULL,
  inits = NULL,
  invariantDrift = NULL,
  iter = NULL,
  lambda = NULL,
  manifestMeans = 0,
  manifestVars = 0,
  mod.names = NULL,
  mod.number = NULL,
  mod.type = "cont",
  moderatedDrift = NULL,
  modsToCompare = NULL,
  nopriors = TRUE,
  optimize = TRUE,
  primaryStudyList = NULL,
  priors = FALSE,
  sameInitialTimes = FALSE,
  scaleClus = TRUE,
  scaleMod = NULL,
  scaleTI = TRUE,
  scaleTime = NULL,
  T0means = 0,
  T0var = "auto",
  transfMod = NULL,
  useSampleFraction = NULL,
  verbose = NULL
)
}
\arguments{
\item{activateRPB}{set to TRUE to receive push messages with 'CoTiMA' notifications on your phone}

\item{activeDirectory}{defines another active directory than the one used in ctmaInitFit}

\item{allInvModel}{estimates a model with all parameters invariant (DRIFT, DIFFUSION, T0VAR) if set TRUE (defautl = FALSE)}

\item{binaries}{which manifest is a binary. Still experimental}

\item{catsToCompare}{when performing contrasts for categorical moderators, the categories (values, not positions) for which effects are set equal}

\item{chains}{number of chains to sample, during HMC or post-optimization importance sampling.}

\item{cint}{default 'auto' (= 0). Are set free if random intercepts model with varying cints is requested (by indvarying='cint')}

\item{cluster}{vector with cluster variables (e.g., countries). Has to be set up carfully. Will be included in \code{\link{ctmaPrep}} in later 'CoTiMA' versions.}

\item{coresToUse}{if negative, the value is subtracted from available cores, else value = cores to use}

\item{CoTiMAStanctArgs}{parameters that can be set to improve model fitting of the \code{\link{ctStanFit}} Function}

\item{ctmaInitFit}{object to which all single ctsem fits of primary studies has been assigned to (i.e., what has been returned by \code{\link{ctmaInit}})}

\item{customPar}{logical. If set TRUE leverages the first pass using priors and ensure that the drift diagonal cannot easily go too negative (helps since ctsem > 3.4)}

\item{digits}{Number of digits used for rounding (in outputs)}

\item{drift}{labels for drift effects. Have to be either of the type 'V1toV2' or '0' for effects to be excluded.}

\item{driftsToCompare}{when performing contrasts for categorical moderators, the (subset of) drift effects analyzed}

\item{equalDrift}{Constrains all listed effects to be equal (e.g., equalDrift = c("V1toV2", "V2toV1")). Note that this is not required for testing the assumption that two effects are equal in the population. Use the invariantDrift argument and then \code{\link{ctmaEqual}})}

\item{finishsamples}{number of samples to draw (either from hessian based covariance or posterior distribution) for final results computation (default = 1000).}

\item{fit}{TRUE (default) fits the requested model. FALSE returns the \code{\link{ctsem}} code CoTiMA uses to set up the model, the ctsemmodelbase which can be modified to match users requirements, and the data set (in long format created). The model can then be fitted using \code{\link{ctStanFit}})}

\item{ind.mod.names}{vector of names for individual level (!) moderators used in output}

\item{ind.mod.number}{which in the vector of individual level (!) moderator values shall be used (e.g., 2 for a single moderator or 1:3 for 3 moderators simultaneously)}

\item{ind.mod.type}{'cont' or 'cat' of the individual level (!) moderators (mixing them in a single model not yet possible)}

\item{indVarying}{allows continuous time intercepts to vary at the individual level (random intercepts model, accounts for unobserved heterogeneity)}

\item{indVaryingT0}{(default = NULL). Automatically set to TRUE if not set to FALSE if indVarying ist set TRUE. indVaryingT0=TRUE forces T0MEANS (T0 scores) to vary interindividually, which undos the nesting of T0(co-)variances in primary studies. Was standard until Aug. 2022. Could provide better estimates if set to FALSE.}

\item{inits}{vector of start values}

\item{invariantDrift}{drift labels for drift effects that are set invariant across primary studies (default = all drift effects).}

\item{iter}{number of iterations (defaul = 1000). Sometimes larger values could be required fom Bayesian estimation}

\item{lambda}{R-type matrix with pattern of fixed (=1) or free (any string) loadings.}

\item{manifestMeans}{default = 0. Are automatically set free is indvarying is set to TRUE. Can be assigned labels to estimate them freely.}

\item{manifestVars}{define the error variances (default = 0) of the manifests with a single time point using R-type lower triangular matrix with nrow=n.manifest & ncol=n.manifest.}

\item{mod.names}{vector of names for moderators used in output}

\item{mod.number}{which in the vector of moderator values shall be used (e.g., 2 for a single moderator or 1:3 for 3 moderators simultaneously)}

\item{mod.type}{'cont' or 'cat' (mixing them in a single model not yet possible)}

\item{moderatedDrift}{labels for drift effects that are moderated (default = all drift effects)}

\item{modsToCompare}{when performing contrasts for categorical moderators, the moderator numbers (position in mod.number) that is used}

\item{nopriors}{Deprecated, but still working. If TRUE, any priors are disabled – sometimes desirable for optimization}

\item{optimize}{if set to FALSE, Stan’s Hamiltonian Monte Carlo sampler is used (default = TRUE = maximum a posteriori / importance sampling) .}

\item{primaryStudyList}{could be a list of primary studies compiled with \code{\link{ctmaPrep}} that defines the subset of studies in ctmaInitFit that should actually be used}

\item{priors}{if FALSE, any priors are disabled – sometimes desirable for optimization}

\item{sameInitialTimes}{Only important for raw data. If TRUE (default=FALSE), T0MEANS occurs for every subject at the same time, rather than just at the earliest observation.}

\item{scaleClus}{scale vector of cluster indicators - TRUE (default) yields avg. drift estimates, FALSE yields drift estimates of last cluster}

\item{scaleMod}{scale moderator variables - TRUE (default) recommended for continuous and categorical moderators, to separate withing and betwen efeccts}

\item{scaleTI}{scale TI predictors - not recommended until version 0.5.3.1. Does not change aggregated results anyways, just interpretation of effects for dummies representing primary studies.}

\item{scaleTime}{scale time (interval) - sometimes desirable to improve fitting}

\item{T0means}{Default 0 (assuming standardized variables). Can be assigned labels to estimate them freely.}

\item{T0var}{(default = 'auto')}

\item{transfMod}{more general option to change moderator values. A vector as long as number of moderators analyzed (e.g., c("mean(x)", "x - median(x)"))}

\item{useSampleFraction}{to speed up debugging. Provided as fraction (e.g., 1/10).}

\item{verbose}{integer from 0 to 2. Higher values print more information during model fit – for debugging}
}
\value{
ctmaFit returns a list containing somearguments supplied, the fitted model, different elements summarizing the main results,
model type, and the type of plot that could be performed with the returned object. The arguments in the returned object are activeDirectory,
coresToUse, moderator names (mod.names), and moderator type (mod.type). Further arguments, which are just copied from the init-fit object
supplied, are, n.latent, studyList, parameterNames, and statisticsList. The fitted model is found in studyFitList, which is a large list
with many elements (e.g., the ctsem model specified by CoTiMA, the rstan model created by ctsem, the fitted rstan model etc.). Further
results returned are n.studies = 1 (required for proper plotting), data (created pseudo raw data), and a list with modelResults (i.e.,
DRIFT=model_Drift_Coef, DIFFUSION=model_Diffusion_Coef, T0VAR=model_T0var_Coef, CINT=model_Cint_Coef, MOD=modTI_Coeff,  and
CLUS=clusTI_Coeff). Possible invariance constraints are included in invariantDrift. The number of moderators simultaneously analyzed are
included in ' n.moderators. The most important new results are returned as the list element "summary", which is printed if the summary
function is applied to the returned object. The summary list element comprises "estimates" (the aggregated effects), possible
randomEffects (not yet fully working),  the minus2ll value and its n.parameters, the opt.lag sensu Dormann & Griffin (2015) and the
max.effects that occur at the opt.lag, clus.effects and mod.effects, and possible warning messages (message). Plot type is
plot.type=c("drift") and model.type="stanct" ("omx" was deprecated).
}
\description{
Fits a ctsem model with invariant drift effects across primary studies, possible multiple moderators (but all of them of the
the same type, either "cont" or "cat"), and possible cluster (e.g., countries where primary studies were conducted).
}
\examples{
\dontrun{
# Example 1. Fit a CoTiMA to all primary studies previously fitted one by one
# with the fits assigned to CoTiMAInitFit_6
CoTiMAFullFit_6 <- ctmaFit(ctmaInitFit=CoTiMAInitFit_6)
summary(CoTiMAFullFit_6)
}

\dontrun{
# Example 2. Fit a CoTiMA with only 2 cross effects invariant (not the auto
# effects) to all primary studies previously fitted one by one with the fits
# assigned to CoTiMAInitFit_6
CoTiMAInitFit_6$activeDirectory <- "/Users/tmp/" # adapt!
CoTiMAFullInv23Fit_6 <- ctmaFit(ctmaInitFit=CoTiMAInitFit_6,
                        invariantDrift=c("V1toV2", "V2toV1"))
summary(CoTiMAFullInv23Fit_6)
}

\dontrun{
# Example 3. Fit a moderated CoTiMA
CoTiMAInitFit_6$activeDirectory <- "/Users/tmp/" # adapt!
CoTiMAMod1onFullFit_6 <- ctmaFit(ctmaInitFit=CoTiMAInitFit_6,
                                 mod.number=1, mod.type="cont",
                                 mod.names=c("Control"))
summary(CoTiMAMod1onFullFit_6)
}

}
