% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codesInUse.R
\name{restrictToCodesInUse}
\alias{restrictToCodesInUse}
\title{Filter a codelist to keep only the codes used in the database}
\usage{
restrictToCodesInUse(
  x,
  cdm,
  table = c("condition_occurrence", "device_exposure", "drug_exposure", "measurement",
    "observation", "procedure_occurrence", "visit_occurrence")
)
}
\arguments{
\item{x}{A codelist}

\item{cdm}{cdm_reference via CDMConnector}

\item{table}{cdm table}
}
\value{
A list of integers indicating the codes used in the database
}
\description{
Filter a codelist to keep only the codes used in the database
}
\examples{
\dontrun{
cdm <- mockVocabRef("database")
codes <- getCandidateCodes(cdm = cdm,
                           keywords = "arthritis",
                           domains = "Condition",
                           includeDescendants = FALSE)
x <- restrictToCodesInUse(list("cs1" = codes$concept_id,
                               "cs2" = 999),
                                cdm = cdm)

x
CDMConnector::cdmDisconnect(cdm)
}
}
