% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCandidateCodes.R
\name{getCandidateCodes}
\alias{getCandidateCodes}
\title{Generate candidate codelist for the OMOP CDM}
\usage{
getCandidateCodes(
  cdm,
  keywords,
  exclude = NULL,
  domains = "Condition",
  standardConcept = "Standard",
  searchInSynonyms = FALSE,
  searchNonStandard = FALSE,
  includeDescendants = TRUE,
  includeAncestor = FALSE
)
}
\arguments{
\item{cdm}{cdm_reference via CDMConnector}

\item{keywords}{Character vector of words to search for.
Where more than one word is given (e.g. "knee osteoarthritis"),
all combinations of those words should be identified
positions (e.g. "osteoarthritis of knee") should be identified.}

\item{exclude}{Character vector of words
to identify concepts to exclude.}

\item{domains}{Character vector with one or more of the OMOP CDM domain.}

\item{standardConcept}{Character vector with one or more of "Standard",
"Classification", and "Non-standard". These correspond to the flags used
for the standard_concept field in the concept table of the cdm.}

\item{searchInSynonyms}{Either TRUE or FALSE. If TRUE the code will also
search using both the primary name in the concept table and synonyms from
the concept synonym table.}

\item{searchNonStandard}{Either TRUE or FALSE. If TRUE the code will also
search via non-standard concepts.}

\item{includeDescendants}{Either TRUE or FALSE.
If TRUE descendant concepts of identified concepts
will be included in the candidate codelist.}

\item{includeAncestor}{Either TRUE or FALSE.
If TRUE the direct ancestor concepts of identified concepts
will be included in the candidate codelist.}
}
\value{
tibble
}
\description{
This function generates a set of codes that
can be considered for creating a phenotype
using the OMOP CDM.
}
\examples{
\donttest{
cdm <- CodelistGenerator::mockVocabRef()
CodelistGenerator::getCandidateCodes(
  cdm = cdm,
  keywords = "osteoarthritis"
 )
}
}
